/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb;

import com.hundsun.lightdb.Driver;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LightdbDriver
extends Driver {
    private static final Logger log = Logger.getLogger("com.hundsun.lightdb");
    public static final String JDBC_LIGHTDB = "jdbc:lightdb:";
    public static final String ONLY_SUPPORT_LIGHT_DB = "This Driver Only Support LightDB";
    private static LightdbDriver registeredLightdbDriver;

    @Override
    protected String acceptPrefix() {
        return JDBC_LIGHTDB;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return super.connect(url, info);
    }

    @Override
    public boolean acceptsURL(String url) {
        return LightdbDriver.parseUrlProperties(url, null, this.acceptPrefix()) != null;
    }

    public static void register() throws SQLException {
        if (LightdbDriver.isRegistered()) {
            throw new IllegalStateException("com.hundsun.lightdb.Driver is already registered. It can only be registered once.");
        }
        LightdbDriver registeredLightdbDriver = new LightdbDriver();
        DriverManager.registerDriver(registeredLightdbDriver);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("LightDB\u9a71\u52a8\u6ce8\u518c\u6210\u529f");
        }
        LightdbDriver.registeredLightdbDriver = registeredLightdbDriver;
    }

    public static boolean isRegistered() {
        return registeredLightdbDriver != null;
    }

    static {
        try {
            LightdbDriver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

