/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.copy;

import com.hundsun.lightdb.copy.CopyDual;
import com.hundsun.lightdb.copy.CopyIn;
import com.hundsun.lightdb.copy.CopyOperation;
import com.hundsun.lightdb.copy.CopyOut;
import com.hundsun.lightdb.core.BaseConnection;
import com.hundsun.lightdb.core.Encoding;
import com.hundsun.lightdb.core.QueryExecutor;
import com.hundsun.lightdb.util.ByteStreamWriter;
import com.hundsun.lightdb.util.GT;
import com.hundsun.lightdb.util.PSQLException;
import com.hundsun.lightdb.util.PSQLState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CopyManager {
    static final int DEFAULT_BUFFER_SIZE = 65536;
    private static final Logger log = Logger.getLogger("com.hundsun.lightdb.copy.CopyManager");
    private final Encoding encoding;
    private final QueryExecutor queryExecutor;
    private final BaseConnection connection;

    public CopyManager(BaseConnection connection) throws SQLException {
        this.encoding = connection.getEncoding();
        this.queryExecutor = connection.getQueryExecutor();
        this.connection = connection;
    }

    public CopyIn copyIn(String sql) throws SQLException {
        CopyOperation op;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("\u5f00\u59cb\u6267\u884ccopyIn " + sql);
        }
        if ((op = this.queryExecutor.startCopy(sql, this.connection.getAutoCommit())) == null || op instanceof CopyIn) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("copyIn\u6210\u529f\u8fd4\u56de " + sql);
            }
            return (CopyIn)op;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("copyIn\u6267\u884c\u51fa\u9519 " + sql);
        }
        op.cancelCopy();
        throw new PSQLException(GT.tr("Requested CopyIn but got {0}", op.getClass().getName()), PSQLState.WRONG_OBJECT_TYPE);
    }

    public CopyOut copyOut(String sql) throws SQLException {
        CopyOperation op;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("\u5f00\u59cb\u6267\u884ccopyOut " + sql);
        }
        if ((op = this.queryExecutor.startCopy(sql, this.connection.getAutoCommit())) == null || op instanceof CopyOut) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("copyOut\u6210\u529f\u8fd4\u56de " + sql);
            }
            return (CopyOut)op;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("copyOut\u6267\u884c\u51fa\u9519 " + sql);
        }
        op.cancelCopy();
        throw new PSQLException(GT.tr("Requested CopyOut but got {0}", op.getClass().getName()), PSQLState.WRONG_OBJECT_TYPE);
    }

    public CopyDual copyDual(String sql) throws SQLException {
        CopyOperation op;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("\u5f00\u59cb\u6267\u884ccopyDual " + sql);
        }
        if ((op = this.queryExecutor.startCopy(sql, this.connection.getAutoCommit())) == null || op instanceof CopyDual) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("copyDual\u6210\u529f\u8fd4\u56de " + sql);
            }
            return (CopyDual)op;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("copyDual\u6267\u884c\u51fa\u9519 " + sql);
        }
        op.cancelCopy();
        throw new PSQLException(GT.tr("Requested CopyDual but got {0}", op.getClass().getName()), PSQLState.WRONG_OBJECT_TYPE);
    }

    public long copyOut(String sql, Writer to) throws SQLException, IOException {
        CopyOut cp = this.copyOut(sql);
        try {
            byte[] buf;
            while ((buf = cp.readFromCopy()) != null) {
                to.write(this.encoding.decode(buf));
            }
            long l = cp.getHandledRowCount();
            return l;
        }
        catch (IOException ioEX) {
            if (cp.isActive()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("copyOut\u6267\u884c\u5f02\u5e38\uff0c\u6267\u884ccancelCopy " + sql);
                }
                cp.cancelCopy();
            }
            try {
                byte[] buf;
                while ((buf = cp.readFromCopy()) != null) {
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw ioEX;
        }
        finally {
            if (cp.isActive()) {
                cp.cancelCopy();
            }
        }
    }

    public long copyOut(String sql, OutputStream to) throws SQLException, IOException {
        CopyOut cp = this.copyOut(sql);
        try {
            byte[] buf;
            while ((buf = cp.readFromCopy()) != null) {
                to.write(buf);
            }
            long l = cp.getHandledRowCount();
            return l;
        }
        catch (IOException ioEX) {
            if (cp.isActive()) {
                cp.cancelCopy();
            }
            try {
                byte[] buf;
                while ((buf = cp.readFromCopy()) != null) {
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw ioEX;
        }
        finally {
            if (cp.isActive()) {
                cp.cancelCopy();
            }
        }
    }

    public long copyIn(String sql, Reader from) throws SQLException, IOException {
        return this.copyIn(sql, from, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyIn(String sql, Reader from, int bufferSize) throws SQLException, IOException {
        char[] cbuf = new char[bufferSize];
        CopyIn cp = this.copyIn(sql);
        try {
            int len;
            while ((len = from.read(cbuf)) >= 0) {
                if (len <= 0) continue;
                byte[] buf = this.encoding.encode(new String(cbuf, 0, len));
                cp.writeToCopy(buf, 0, buf.length);
            }
            long l = cp.endCopy();
            return l;
        }
        finally {
            if (cp.isActive()) {
                cp.cancelCopy();
            }
        }
    }

    public long copyIn(String sql, InputStream from) throws SQLException, IOException {
        return this.copyIn(sql, from, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyIn(String sql, InputStream from, int bufferSize) throws SQLException, IOException {
        byte[] buf = new byte[bufferSize];
        CopyIn cp = this.copyIn(sql);
        try {
            int len;
            while ((len = from.read(buf)) >= 0) {
                if (len <= 0) continue;
                cp.writeToCopy(buf, 0, len);
            }
            long l = cp.endCopy();
            return l;
        }
        finally {
            if (cp.isActive()) {
                cp.cancelCopy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyIn(String sql, ByteStreamWriter from) throws SQLException, IOException {
        CopyIn cp = this.copyIn(sql);
        try {
            cp.writeToCopy(from);
            long l = cp.endCopy();
            return l;
        }
        finally {
            if (cp.isActive()) {
                cp.cancelCopy();
            }
        }
    }
}

