/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.copy;

import com.hundsun.lightdb.PGConnection;
import com.hundsun.lightdb.copy.CopyOut;
import com.hundsun.lightdb.util.GT;
import com.hundsun.lightdb.util.PSQLException;
import com.hundsun.lightdb.util.PSQLState;
import com.hundsun.lightdb.util.internal.Nullness;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PGCopyInputStream
extends InputStream
implements CopyOut {
    private CopyOut op;
    private byte[] buf;
    private int at;
    private int len;
    private static final Logger log = Logger.getLogger("com.hundsun.lightdb.copy.PGCopyInputStream");

    public PGCopyInputStream(PGConnection connection, String sql) throws SQLException {
        this(connection.getCopyAPI().copyOut(sql));
    }

    public PGCopyInputStream(CopyOut op) {
        this.op = op;
    }

    private CopyOut getOp() {
        return Nullness.castNonNull(this.op);
    }

    private byte[] fillBuffer() throws IOException {
        if (this.at >= this.len) {
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("fillBuffer at:" + this.at + " len:" + this.len);
                }
                this.buf = this.getOp().readFromCopy();
            }
            catch (SQLException sqle) {
                throw new IOException(GT.tr("Copying from database failed: {0}", sqle.getMessage()), sqle);
            }
            if (this.buf == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("buf \u4e3a null");
                }
                this.at = -1;
            } else {
                this.at = 0;
                this.len = this.buf.length;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("buf \u4e0d\u4e3a null at:" + this.at + " len:" + this.len);
                }
            }
        }
        return this.buf;
    }

    private void checkClosed() throws IOException {
        if (this.op == null) {
            throw new IOException(GT.tr("This copy stream is closed.", new Object[0]));
        }
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        return this.buf != null ? this.len - this.at : 0;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        byte[] buf = this.fillBuffer();
        return buf != null ? buf[this.at++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int siz) throws IOException {
        int got;
        int length;
        this.checkClosed();
        byte[] data = this.fillBuffer();
        for (got = 0; got < siz && data != null; got += length) {
            length = Math.min(siz - got, this.len - this.at);
            System.arraycopy(data, this.at, buf, off + got, length);
            this.at += length;
            data = this.fillBuffer();
        }
        return got == 0 && data == null ? -1 : got;
    }

    @Override
    public byte[] readFromCopy() throws SQLException {
        byte[] result = null;
        try {
            byte[] buf = this.fillBuffer();
            if (buf != null) {
                result = this.at > 0 || this.len < buf.length ? Arrays.copyOfRange(buf, this.at, this.len) : buf;
                this.at = this.len;
            }
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Read from copy failed.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
        return result;
    }

    @Override
    public byte[] readFromCopy(boolean block) throws SQLException {
        return this.readFromCopy();
    }

    @Override
    public void close() throws IOException {
        if (this.op == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("close() op \u4e3a null");
            }
            return;
        }
        if (this.op.isActive()) {
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("close() op isActive");
                }
                this.op.cancelCopy();
            }
            catch (SQLException se) {
                throw new IOException("Failed to close copy reader.", se);
            }
        }
        this.op = null;
    }

    @Override
    public void cancelCopy() throws SQLException {
        this.getOp().cancelCopy();
    }

    @Override
    public int getFormat() {
        return this.getOp().getFormat();
    }

    @Override
    public int getFieldFormat(int field) {
        return this.getOp().getFieldFormat(field);
    }

    @Override
    public int getFieldCount() {
        return this.getOp().getFieldCount();
    }

    @Override
    public boolean isActive() {
        return this.op != null && this.op.isActive();
    }

    @Override
    public long getHandledRowCount() {
        return this.getOp().getHandledRowCount();
    }
}

