/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core;

import com.hundsun.lightdb.core.BaseQueryKey;
import com.hundsun.lightdb.core.CachedQuery;
import com.hundsun.lightdb.core.CallableQueryKey;
import com.hundsun.lightdb.core.JdbcCallParseInfo;
import com.hundsun.lightdb.core.NativeQuery;
import com.hundsun.lightdb.core.Parser;
import com.hundsun.lightdb.core.Query;
import com.hundsun.lightdb.core.QueryExecutor;
import com.hundsun.lightdb.core.QueryWithReturningColumnsKey;
import com.hundsun.lightdb.jdbc.PreferQueryMode;
import com.hundsun.lightdb.util.LruCache;
import com.hundsun.lightdb.util.SqlPreHandler;
import com.hundsun.lightdb.util.internal.Nullness;
import java.sql.SQLException;
import java.util.List;

class CachedQueryCreateAction
implements LruCache.CreateAction<Object, CachedQuery> {
    private static final String[] EMPTY_RETURNING = new String[0];
    private final QueryExecutor queryExecutor;

    CachedQueryCreateAction(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    @Override
    public CachedQuery create(Object key) throws SQLException {
        boolean isFunction;
        String parsedSql;
        BaseQueryKey queryKey;
        assert (key instanceof String || key instanceof BaseQueryKey) : "Query key should be String or BaseQueryKey. Given " + key.getClass() + ", sql: " + key;
        if (key instanceof BaseQueryKey) {
            queryKey = (BaseQueryKey)key;
            parsedSql = queryKey.sql;
        } else {
            queryKey = null;
            parsedSql = (String)key;
        }
        if (key instanceof String || Nullness.castNonNull(queryKey).escapeProcessing) {
            parsedSql = Parser.replaceProcessing(parsedSql, true, this.queryExecutor.getStandardConformingStrings());
        }
        if (key instanceof CallableQueryKey) {
            JdbcCallParseInfo callInfo = Parser.modifyJdbcCall(parsedSql, this.queryExecutor.getStandardConformingStrings(), this.queryExecutor.getServerVersionNum(), this.queryExecutor.getProtocolVersion(), this.queryExecutor.getEscapeSyntaxCallMode());
            parsedSql = callInfo.getSql();
            isFunction = callInfo.isFunction();
        } else {
            isFunction = false;
        }
        boolean isParameterized = key instanceof String || Nullness.castNonNull(queryKey).isParameterized;
        boolean splitStatements = isParameterized || this.queryExecutor.getPreferQueryMode().compareTo(PreferQueryMode.EXTENDED) >= 0;
        String[] returningColumns = key instanceof QueryWithReturningColumnsKey ? ((QueryWithReturningColumnsKey)key).columnNames : EMPTY_RETURNING;
        parsedSql = SqlPreHandler.cleanFoundRows(this.queryExecutor, parsedSql);
        parsedSql = SqlPreHandler.cleanEmptyChar(this.queryExecutor, parsedSql);
        List<NativeQuery> queries = Parser.parseJdbcSql(parsedSql, this.queryExecutor.getStandardConformingStrings(), isParameterized, splitStatements, this.queryExecutor.isReWriteBatchedInsertsEnabled(), returningColumns);
        Query query = this.queryExecutor.wrap(queries);
        return new CachedQuery(key, query, isFunction);
    }
}

