/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core;

import com.hundsun.lightdb.PGProperty;
import com.hundsun.lightdb.core.PGStream;
import com.hundsun.lightdb.core.QueryExecutor;
import com.hundsun.lightdb.core.v3.ConnectionFactoryImpl;
import com.hundsun.lightdb.util.GT;
import com.hundsun.lightdb.util.HostSpec;
import com.hundsun.lightdb.util.PSQLException;
import com.hundsun.lightdb.util.PSQLState;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;

public abstract class ConnectionFactory {
    public static QueryExecutor openConnection(HostSpec[] hostSpecs, String user, String database, Properties info) throws SQLException {
        ConnectionFactoryImpl connectionFactory;
        QueryExecutor queryExecutor;
        String protoName = PGProperty.PROTOCOL_VERSION.get(info);
        if ((protoName == null || protoName.isEmpty() || "3".equals(protoName)) && (queryExecutor = ((ConnectionFactory)(connectionFactory = new ConnectionFactoryImpl())).openConnectionImpl(hostSpecs, user, database, info)) != null) {
            return queryExecutor;
        }
        throw new PSQLException(GT.tr("A connection could not be made using the requested protocol {0}.", protoName), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract QueryExecutor openConnectionImpl(HostSpec[] var1, String var2, String var3, Properties var4) throws SQLException;

    protected void closeStream(PGStream newStream) {
        if (newStream != null) {
            try {
                newStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

