/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core;

import com.hundsun.lightdb.core.Field;
import com.hundsun.lightdb.core.Query;
import com.hundsun.lightdb.core.ResultCursor;
import com.hundsun.lightdb.core.ResultHandler;
import com.hundsun.lightdb.core.Tuple;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;

public class ResultHandlerDelegate
implements ResultHandler {
    private final ResultHandler delegate;

    public ResultHandlerDelegate(ResultHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, ResultCursor cursor) {
        if (this.delegate != null) {
            this.delegate.handleResultRows(fromQuery, fields, tuples, cursor);
        }
    }

    @Override
    public void handleCommandStatus(String status, long updateCount, long insertOID) {
        if (this.delegate != null) {
            this.delegate.handleCommandStatus(status, updateCount, insertOID);
        }
    }

    @Override
    public void handleWarning(SQLWarning warning) {
        if (this.delegate != null) {
            this.delegate.handleWarning(warning);
        }
    }

    @Override
    public void handleError(SQLException error) {
        if (this.delegate != null) {
            this.delegate.handleError(error);
        }
    }

    @Override
    public void handleCompletion() throws SQLException {
        if (this.delegate != null) {
            this.delegate.handleCompletion();
        }
    }

    @Override
    public void secureProgress() {
        if (this.delegate != null) {
            this.delegate.secureProgress();
        }
    }

    @Override
    public SQLException getException() {
        if (this.delegate != null) {
            return this.delegate.getException();
        }
        return null;
    }

    @Override
    public SQLWarning getWarning() {
        if (this.delegate != null) {
            return this.delegate.getWarning();
        }
        return null;
    }
}

