/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core;

import com.hundsun.lightdb.PGProperty;
import com.hundsun.lightdb.ssl.LibPQFactory;
import com.hundsun.lightdb.util.GT;
import com.hundsun.lightdb.util.ObjectFactory;
import com.hundsun.lightdb.util.PSQLException;
import com.hundsun.lightdb.util.PSQLState;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SocketFactoryFactory {
    public static SocketFactory getSocketFactory(Properties info) throws PSQLException {
        String socketFactoryClassName = PGProperty.SOCKET_FACTORY.get(info);
        if (socketFactoryClassName == null) {
            return SocketFactory.getDefault();
        }
        try {
            return ObjectFactory.instantiate(SocketFactory.class, socketFactoryClassName, info, true, PGProperty.SOCKET_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The SocketFactory class provided {0} could not be instantiated.", socketFactoryClassName), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(Properties info) throws PSQLException {
        String classname = PGProperty.SSL_FACTORY.get(info);
        if (classname == null || "com.hundsun.lightdb.ssl.jdbc4.LibPQFactory".equals(classname) || "com.hundsun.lightdb.ssl.LibPQFactory".equals(classname)) {
            return new LibPQFactory(info);
        }
        try {
            return ObjectFactory.instantiate(SSLSocketFactory.class, classname, info, true, PGProperty.SSL_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }
}

