/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.v3;

import com.hundsun.lightdb.core.NativeQuery;
import com.hundsun.lightdb.core.ParameterList;
import com.hundsun.lightdb.core.v3.SimpleQuery;
import com.hundsun.lightdb.core.v3.TypeTransferModeRegistry;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BatchedQuery
extends SimpleQuery {
    private static final Logger log = Logger.getLogger(BatchedQuery.class.getName());
    private String sql;
    private final int valuesBraceOpenPosition;
    private final int valuesBraceClosePosition;
    private final int batchSize;
    private BatchedQuery[] blocks;

    public BatchedQuery(NativeQuery query, TypeTransferModeRegistry transferModeRegistry, int valuesBraceOpenPosition, int valuesBraceClosePosition, boolean sanitiserDisabled) {
        super(query, transferModeRegistry, sanitiserDisabled);
        this.valuesBraceOpenPosition = valuesBraceOpenPosition;
        this.valuesBraceClosePosition = valuesBraceClosePosition;
        this.batchSize = 1;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("batchSize = 1");
        }
    }

    private BatchedQuery(BatchedQuery src, int batchSize) {
        super(src);
        this.valuesBraceOpenPosition = src.valuesBraceOpenPosition;
        this.valuesBraceClosePosition = src.valuesBraceClosePosition;
        this.batchSize = batchSize;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("batchSize = " + batchSize);
        }
    }

    public BatchedQuery deriveForMultiBatch(int valueBlock) {
        BatchedQuery bq;
        if (this.getBatchSize() != 1) {
            throw new IllegalStateException("Only the original decorator can be derived.");
        }
        if (valueBlock == 1) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("valueBlock == 1");
            }
            return this;
        }
        int index = Integer.numberOfTrailingZeros(valueBlock) - 1;
        if (valueBlock > 128 || valueBlock != 1 << index + 1) {
            throw new IllegalArgumentException("Expected value block should be a power of 2 smaller or equal to 128. Actual block is " + valueBlock);
        }
        if (this.blocks == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("blocks == null");
            }
            this.blocks = new BatchedQuery[7];
        }
        if ((bq = this.blocks[index]) == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("bq == null");
            }
            this.blocks[index] = bq = new BatchedQuery(this, valueBlock);
        }
        return bq;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public String getNativeSql() {
        if (this.sql != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("getNativeSql sql: " + this.sql);
            }
            return this.sql;
        }
        this.sql = this.buildNativeSql(null);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("buildNativeSql sql: " + this.sql);
        }
        return this.sql;
    }

    private String buildNativeSql(ParameterList params) {
        int pos;
        String sql = null;
        String nativeSql = super.getNativeSql();
        int batchSize = this.getBatchSize();
        if (batchSize < 2) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("batchSize < 2 batchSize: " + batchSize);
            }
            sql = nativeSql;
            return sql;
        }
        if (nativeSql == null) {
            sql = "";
            if (log.isLoggable(Level.FINEST)) {
                log.finest("nativeSql == null");
            }
            return sql;
        }
        int valuesBlockCharCount = 0;
        int[] bindPositions = this.getNativeQuery().bindPositions;
        int[] chunkStart = new int[1 + bindPositions.length];
        int[] chunkEnd = new int[1 + bindPositions.length];
        chunkStart[0] = this.valuesBraceOpenPosition;
        if (bindPositions.length == 0) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("bindPositions.length == 0");
            }
            valuesBlockCharCount = this.valuesBraceClosePosition - this.valuesBraceOpenPosition + 1;
            chunkEnd[0] = this.valuesBraceClosePosition + 1;
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("bindPositions.length != 0");
            }
            chunkEnd[0] = bindPositions[0];
            valuesBlockCharCount += chunkEnd[0] - chunkStart[0];
            for (int i = 0; i < bindPositions.length; ++i) {
                int startIndex;
                int endIndex;
                int n = endIndex = i < bindPositions.length - 1 ? bindPositions[i + 1] : this.valuesBraceClosePosition + 1;
                for (startIndex = bindPositions[i] + 2; startIndex < endIndex; ++startIndex) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("startIndex: " + startIndex);
                    }
                    if (Character.isDigit(nativeSql.charAt(startIndex))) continue;
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.finest("\u8d77\u59cb\u7d22\u5f15\u5b57\u7b26\u975e\u6570\u5b57\uff0c\u9000\u51fa\u5faa\u73af: " + nativeSql.charAt(startIndex));
                    break;
                }
                chunkStart[i + 1] = startIndex;
                chunkEnd[i + 1] = endIndex;
                valuesBlockCharCount += chunkEnd[i + 1] - chunkStart[i + 1];
            }
        }
        int length = nativeSql.length();
        length += NativeQuery.calculateBindLength(bindPositions.length * batchSize);
        length -= NativeQuery.calculateBindLength(bindPositions.length);
        StringBuilder s = new StringBuilder(length += (valuesBlockCharCount + 1) * (batchSize - 1));
        if (bindPositions.length > 0 && params == null) {
            s.append(nativeSql, 0, this.valuesBraceClosePosition + 1);
            pos = bindPositions.length + 1;
        } else {
            pos = 1;
            ++batchSize;
            s.append(nativeSql, 0, this.valuesBraceOpenPosition);
        }
        for (int i = 2; i <= batchSize; ++i) {
            if (i > 2 || pos != 1) {
                s.append(',');
            }
            s.append(nativeSql, chunkStart[0], chunkEnd[0]);
            for (int j = 1; j < chunkStart.length; ++j) {
                if (params == null) {
                    NativeQuery.appendBindName(s, pos++);
                } else {
                    s.append(params.toString(pos++, true));
                }
                s.append(nativeSql, chunkStart[j], chunkEnd[j]);
            }
        }
        s.append(nativeSql, this.valuesBraceClosePosition + 1, nativeSql.length());
        sql = s.toString();
        assert (params != null || s.length() == length) : "Predicted length != actual: " + length + " !=" + s.length();
        return sql;
    }

    @Override
    public String toString(ParameterList params) {
        if (this.getBatchSize() < 2) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("getBatchSize() < 2 " + this.getBatchSize());
            }
            return super.toString(params);
        }
        return this.buildNativeSql(params);
    }
}

