/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.v3;

import com.hundsun.lightdb.PGProperty;
import com.hundsun.lightdb.core.ConnectionFactory;
import com.hundsun.lightdb.core.PGStream;
import com.hundsun.lightdb.core.QueryExecutor;
import com.hundsun.lightdb.core.ServerVersion;
import com.hundsun.lightdb.core.SetupQueryRunner;
import com.hundsun.lightdb.core.SocketFactoryFactory;
import com.hundsun.lightdb.core.Tuple;
import com.hundsun.lightdb.core.Utils;
import com.hundsun.lightdb.core.Version;
import com.hundsun.lightdb.core.v3.QueryExecutorImpl;
import com.hundsun.lightdb.hostchooser.CandidateHost;
import com.hundsun.lightdb.hostchooser.GlobalHostStatusTracker;
import com.hundsun.lightdb.hostchooser.HostChooser;
import com.hundsun.lightdb.hostchooser.HostChooserFactory;
import com.hundsun.lightdb.hostchooser.HostRequirement;
import com.hundsun.lightdb.hostchooser.HostStatus;
import com.hundsun.lightdb.jdbc.GSSEncMode;
import com.hundsun.lightdb.jdbc.SslMode;
import com.hundsun.lightdb.ssl.MakeSSL;
import com.hundsun.lightdb.util.GT;
import com.hundsun.lightdb.util.HostSpec;
import com.hundsun.lightdb.util.MD5Digest;
import com.hundsun.lightdb.util.PSQLException;
import com.hundsun.lightdb.util.PSQLState;
import com.hundsun.lightdb.util.SM3AuthDigest;
import com.hundsun.lightdb.util.ServerErrorMessage;
import com.hundsun.lightdb.util.internal.Nullness;
import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.SocketFactory;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final Logger log = Logger.getLogger(ConnectionFactoryImpl.class.getName());
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SM3 = 13;

    private PGStream tryConnect(String user, String database, Properties info, SocketFactory socketFactory, HostSpec hostSpec, SslMode sslMode, GSSEncMode gssEncMode) throws SQLException, IOException {
        int sendBufferSize;
        int connectTimeout = PGProperty.CONNECT_TIMEOUT.getInt(info) * 1000;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("connectTimeout: " + connectTimeout);
        }
        PGStream newStream = new PGStream(socketFactory, hostSpec, connectTimeout);
        int socketTimeout = PGProperty.SOCKET_TIMEOUT.getInt(info);
        if (socketTimeout > 0) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("socketTimeout: " + socketTimeout);
            }
            newStream.setNetworkTimeout(socketTimeout * 1000);
        }
        String maxResultBuffer = PGProperty.MAX_RESULT_BUFFER.get(info);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("maxResultBuffer: " + maxResultBuffer);
        }
        newStream.setMaxResultBuffer(maxResultBuffer);
        boolean requireTCPKeepAlive = PGProperty.TCP_KEEP_ALIVE.getBoolean(info);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("requireTCPKeepAlive: " + requireTCPKeepAlive);
        }
        newStream.getSocket().setKeepAlive(requireTCPKeepAlive);
        int receiveBufferSize = PGProperty.RECEIVE_BUFFER_SIZE.getInt(info);
        if (receiveBufferSize > -1) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("receiveBufferSize: " + receiveBufferSize);
            }
            if (receiveBufferSize > 0) {
                newStream.getSocket().setReceiveBufferSize(receiveBufferSize);
            } else {
                log.log(Level.WARNING, "Ignore invalid value for receiveBufferSize: {0}", receiveBufferSize);
            }
        }
        if ((sendBufferSize = PGProperty.SEND_BUFFER_SIZE.getInt(info)) > -1) {
            if (sendBufferSize > 0) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("sendBufferSize: " + sendBufferSize);
                }
                newStream.getSocket().setSendBufferSize(sendBufferSize);
            } else {
                log.log(Level.WARNING, "Ignore invalid value for sendBufferSize: {0}", sendBufferSize);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Receive Buffer Size is {0}", newStream.getSocket().getReceiveBufferSize());
            log.log(Level.FINE, "Send Buffer Size is {0}", newStream.getSocket().getSendBufferSize());
        }
        if (!(newStream = this.enableGSSEncrypted(newStream, gssEncMode, hostSpec.getHost(), user, info, connectTimeout)).isGssEncrypted()) {
            newStream = this.enableSSL(newStream, sslMode, info, connectTimeout);
        }
        if (socketTimeout > 0) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("socketTimeout: " + socketTimeout);
            }
            newStream.setNetworkTimeout(socketTimeout * 1000);
        }
        List<String[]> paramList = this.getParametersForStartup(user, database, info);
        this.sendStartupPacket(newStream, paramList);
        this.doAuthentication(newStream, hostSpec.getHost(), user, info);
        return newStream;
    }

    @Override
    public QueryExecutor openConnectionImpl(HostSpec[] hostSpecs, String user, String database, Properties info) throws SQLException {
        HostRequirement targetServerType;
        SslMode sslMode = SslMode.of(info);
        GSSEncMode gssEncMode = GSSEncMode.of(info);
        String targetServerTypeStr = Nullness.castNonNull(PGProperty.TARGET_SERVER_TYPE.get(info));
        try {
            targetServerType = HostRequirement.getTargetServerType(targetServerTypeStr);
        }
        catch (IllegalArgumentException ex) {
            throw new PSQLException(GT.tr("Invalid targetServerType value: {0}", targetServerTypeStr), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        SocketFactory socketFactory = SocketFactoryFactory.getSocketFactory(info);
        HostChooser hostChooser = HostChooserFactory.createHostChooser(hostSpecs, targetServerType, info);
        Iterator<CandidateHost> hostIter = hostChooser.iterator();
        HashMap<HostSpec, HostStatus> knownStates = new HashMap<HostSpec, HostStatus>();
        while (hostIter.hasNext()) {
            CandidateHost candidateHost = hostIter.next();
            HostSpec hostSpec = candidateHost.hostSpec;
            log.log(Level.FINE, "Trying to establish a protocol version 3 connection to {0}", hostSpec);
            HostStatus knownStatus = (HostStatus)((Object)knownStates.get(hostSpec));
            if (knownStatus != null && !candidateHost.targetServerType.allowConnectingTo(knownStatus)) {
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, "Known status of host {0} is {1}, and required status was {2}. Will try next host", new Object[]{hostSpec, knownStatus, candidateHost.targetServerType});
                continue;
            }
            PGStream newStream = null;
            try {
                try {
                    newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, sslMode, gssEncMode);
                }
                catch (SQLException e) {
                    Exception ex;
                    if (sslMode == SslMode.PREFER && PSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(e.getSQLState())) {
                        ex = null;
                        try {
                            newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, SslMode.DISABLE, gssEncMode);
                            log.log(Level.FINE, "Downgraded to non-encrypted connection for host {0}", hostSpec);
                        }
                        catch (SQLException ee) {
                            ex = ee;
                        }
                        catch (IOException ee) {
                            ex = ee;
                        }
                        if (ex != null) {
                            ConnectionFactoryImpl.log(Level.FINE, "sslMode==PREFER, however non-SSL connection failed as well", ex, new Object[0]);
                            e.addSuppressed(ex);
                            throw e;
                        }
                    }
                    if (sslMode == SslMode.ALLOW && PSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(e.getSQLState())) {
                        ex = null;
                        try {
                            newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, SslMode.REQUIRE, gssEncMode);
                            log.log(Level.FINE, "Upgraded to encrypted connection for host {0}", hostSpec);
                        }
                        catch (SQLException ee) {
                            ex = ee;
                        }
                        catch (IOException ee) {
                            ex = ee;
                        }
                        if (ex != null) {
                            ConnectionFactoryImpl.log(Level.FINE, "sslMode==ALLOW, however SSL connection failed as well", ex, new Object[0]);
                            e.addSuppressed(ex);
                            throw e;
                        }
                    }
                    throw e;
                }
                int cancelSignalTimeout = PGProperty.CANCEL_SIGNAL_TIMEOUT.getInt(info) * 1000;
                Nullness.castNonNull(newStream);
                QueryExecutorImpl queryExecutor = new QueryExecutorImpl(newStream, user, database, cancelSignalTimeout, info);
                HostStatus hostStatus = HostStatus.ConnectOK;
                if (candidateHost.targetServerType != HostRequirement.any) {
                    HostStatus hostStatus2 = hostStatus = this.isPrimary(queryExecutor) ? HostStatus.Primary : HostStatus.Secondary;
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("hostStatus: " + (Object)((Object)hostStatus));
                    }
                }
                GlobalHostStatusTracker.reportHostStatus(hostSpec, hostStatus);
                knownStates.put(hostSpec, hostStatus);
                if (!candidateHost.targetServerType.allowConnectingTo(hostStatus)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("queryExecutor.close()");
                    }
                    queryExecutor.close();
                    continue;
                }
                this.runInitialQueries(queryExecutor, info);
                return queryExecutor;
            }
            catch (ConnectException cex) {
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    ConnectionFactoryImpl.log(Level.FINE, "ConnectException occurred while connecting to {0}", cex, hostSpec);
                    continue;
                }
                throw new PSQLException(GT.tr("Connection to {0} refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections.", hostSpec), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
            }
            catch (IOException ioe) {
                this.closeStream(newStream);
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    ConnectionFactoryImpl.log(Level.FINE, "IOException occurred while connecting to {0}", ioe, hostSpec);
                    continue;
                }
                throw new PSQLException(GT.tr("The connection attempt failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
            }
            catch (SQLException se) {
                this.closeStream(newStream);
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    ConnectionFactoryImpl.log(Level.FINE, "SQLException occurred while connecting to {0}", se, hostSpec);
                    continue;
                }
                throw se;
            }
        }
        throw new PSQLException(GT.tr("Could not find a server with specified targetServerType: {0}", new Object[]{targetServerType}), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private List<String[]> getParametersForStartup(String user, String database, Properties info) {
        String options;
        String currentSchema;
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        paramList.add(new String[]{"user", user});
        paramList.add(new String[]{"database", database});
        paramList.add(new String[]{"client_encoding", "UTF8"});
        paramList.add(new String[]{"DateStyle", "ISO"});
        paramList.add(new String[]{"TimeZone", ConnectionFactoryImpl.createPostgresTimeZone()});
        Version assumeVersion = ServerVersion.from(PGProperty.ASSUME_MIN_SERVER_VERSION.get(info));
        if (assumeVersion.getVersionNum() >= ServerVersion.v9_0.getVersionNum()) {
            String appName;
            paramList.add(new String[]{"extra_float_digits", "3"});
            if (log.isLoggable(Level.FINEST)) {
                log.finest("assumeVersion.getVersionNum() >= ServerVersion.v9_0.getVersionNum()");
            }
            if ((appName = PGProperty.APPLICATION_NAME.get(info)) != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("application_name: " + appName);
                }
                paramList.add(new String[]{"application_name", appName});
            }
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("assumeVersion.getVersionNum() < ServerVersion.v9_0.getVersionNum()");
            }
            paramList.add(new String[]{"extra_float_digits", "2"});
        }
        String replication = PGProperty.REPLICATION.get(info);
        if (replication != null && assumeVersion.getVersionNum() >= ServerVersion.v9_4.getVersionNum()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("replication: " + replication);
            }
            paramList.add(new String[]{"replication", replication});
        }
        if ((currentSchema = PGProperty.CURRENT_SCHEMA.get(info)) != null) {
            String extendSchema;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("currentSchema: " + currentSchema);
            }
            if ((extendSchema = PGProperty.EXTEND_SCHEMA.get(info)) != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("extendSchema: " + extendSchema);
                }
                currentSchema = String.format("%s,%s", currentSchema, extendSchema);
            }
            paramList.add(new String[]{"search_path", currentSchema});
        }
        if ((options = PGProperty.OPTIONS.get(info)) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("options: " + options);
            }
            paramList.add(new String[]{"options", options});
        }
        return paramList;
    }

    private static void log(Level level, String msg, Throwable thrown, Object ... params) {
        if (!log.isLoggable(level)) {
            return;
        }
        LogRecord rec = new LogRecord(level, msg);
        rec.setLoggerName(log.getName());
        rec.setParameters(params);
        rec.setThrown(thrown);
        log.log(rec);
    }

    private static String createPostgresTimeZone() {
        String start;
        String tz = TimeZone.getDefault().getID();
        if (tz.length() <= 3 || !tz.startsWith("GMT")) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("tz.length() <= 3 || !tz.startsWith(\"GMT\")");
            }
            return tz;
        }
        char sign = tz.charAt(3);
        switch (sign) {
            case '+': {
                start = "GMT-";
                break;
            }
            case '-': {
                start = "GMT+";
                break;
            }
            default: {
                return tz;
            }
        }
        return start + tz.substring(4);
    }

    private PGStream enableGSSEncrypted(PGStream pgStream, GSSEncMode gssEncMode, String host, String user, Properties info, int connectTimeout) throws IOException, PSQLException {
        if (gssEncMode == GSSEncMode.DISABLE) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("gssEncMode == GSSEncMode.DISABLE");
            }
            return pgStream;
        }
        if (gssEncMode == GSSEncMode.ALLOW) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("gssEncMode == GSSEncMode.ALLOW");
            }
            return pgStream;
        }
        String password = PGProperty.PASSWORD.get(info);
        log.log(Level.FINEST, " FE=> GSSENCRequest");
        pgStream.sendInteger4(8);
        pgStream.sendInteger2(1234);
        pgStream.sendInteger2(5680);
        pgStream.flush();
        int beresp = pgStream.receiveChar();
        switch (beresp) {
            case 69: {
                log.log(Level.FINEST, " <=BE GSSEncrypted Error");
                if (gssEncMode.requireEncryption()) {
                    throw new PSQLException(GT.tr("The server does not support GSS Encoding.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                pgStream.close();
                return new PGStream(pgStream.getSocketFactory(), pgStream.getHostSpec(), connectTimeout);
            }
            case 78: {
                log.log(Level.FINEST, " <=BE GSSEncrypted Refused");
                if (gssEncMode.requireEncryption()) {
                    throw new PSQLException(GT.tr("The server does not support GSS Encryption.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                return pgStream;
            }
        }
        throw new PSQLException(GT.tr("An error occurred while setting up the GSS Encoded connection.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
    }

    private PGStream enableSSL(PGStream pgStream, SslMode sslMode, Properties info, int connectTimeout) throws IOException, PSQLException {
        if (sslMode == SslMode.DISABLE) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("sslMode == SslMode.DISABLE");
            }
            return pgStream;
        }
        if (sslMode == SslMode.ALLOW) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("sslMode == SslMode.ALLOW");
            }
            return pgStream;
        }
        log.log(Level.FINEST, " FE=> SSLRequest");
        pgStream.sendInteger4(8);
        pgStream.sendInteger2(1234);
        pgStream.sendInteger2(5679);
        pgStream.flush();
        int beresp = pgStream.receiveChar();
        switch (beresp) {
            case 69: {
                log.log(Level.FINEST, " <=BE SSLError");
                if (sslMode.requireEncryption()) {
                    throw new PSQLException(GT.tr("The server does not support SSL.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                return new PGStream(pgStream, connectTimeout);
            }
            case 78: {
                log.log(Level.FINEST, " <=BE SSLRefused");
                if (sslMode.requireEncryption()) {
                    throw new PSQLException(GT.tr("The server does not support SSL.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                return pgStream;
            }
            case 83: {
                log.log(Level.FINEST, " <=BE SSLOk");
                MakeSSL.convert(pgStream, info);
                return pgStream;
            }
        }
        throw new PSQLException(GT.tr("An error occurred while setting up the SSL connection.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
    }

    private void sendStartupPacket(PGStream pgStream, List<String[]> params) throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            StringBuilder details = new StringBuilder();
            for (int i = 0; i < params.size(); ++i) {
                if (i != 0) {
                    details.append(", ");
                }
                details.append(params.get(i)[0]);
                details.append("=");
                details.append(params.get(i)[1]);
            }
            log.log(Level.FINEST, " FE=> StartupPacket({0})", details);
        }
        int length = 8;
        byte[][] encodedParams = new byte[params.size() * 2][];
        for (int i = 0; i < params.size(); ++i) {
            encodedParams[i * 2] = params.get(i)[0].getBytes("UTF-8");
            encodedParams[i * 2 + 1] = params.get(i)[1].getBytes("UTF-8");
            length += encodedParams[i * 2].length + 1 + encodedParams[i * 2 + 1].length + 1;
        }
        pgStream.sendInteger4(++length);
        pgStream.sendInteger2(3);
        pgStream.sendInteger2(0);
        for (byte[] encodedParam : encodedParams) {
            pgStream.send(encodedParam);
            pgStream.sendChar(0);
        }
        pgStream.sendChar(0);
        pgStream.flush();
    }

    private void doAuthentication(PGStream pgStream, String host, String user, Properties info) throws IOException, SQLException {
        String password = PGProperty.PASSWORD.get(info);
        block10: while (true) {
            int beresp = pgStream.receiveChar();
            block0 : switch (beresp) {
                case 69: {
                    int elen = pgStream.receiveInteger4();
                    ServerErrorMessage errorMsg = new ServerErrorMessage(pgStream.receiveErrorString(elen - 4));
                    log.log(Level.FINEST, " <=BE ErrorMessage({0})", errorMsg);
                    throw new PSQLException(errorMsg, PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                }
                case 82: {
                    int msgLen = pgStream.receiveInteger4();
                    int areq = pgStream.receiveInteger4();
                    switch (areq) {
                        case 5: {
                            byte[] md5Salt = pgStream.receive(4);
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, " <=BE AuthenticationReqMD5(salt={0})", Utils.toHexString(md5Salt));
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] digest = MD5Digest.encode(user.getBytes("UTF-8"), password.getBytes("UTF-8"), md5Salt);
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, " FE=> Password(md5digest={0})", new String(digest, "US-ASCII"));
                            }
                            pgStream.sendChar(112);
                            pgStream.sendInteger4(4 + digest.length + 1);
                            pgStream.send(digest);
                            pgStream.sendChar(0);
                            pgStream.flush();
                            break block0;
                        }
                        case 13: {
                            byte[] sm3Salt = pgStream.receive(16);
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, " <=BE AuthenticationReqSM3(salt={0})", Utils.toHexString(sm3Salt));
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] sm3Digest = SM3AuthDigest.encode(user.getBytes("UTF-8"), password.getBytes("UTF-8"), sm3Salt);
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, " FE=> Password(sm3digest={0})", new String(sm3Digest, "US-ASCII"));
                            }
                            pgStream.sendChar(112);
                            pgStream.sendInteger4(4 + sm3Digest.length + 1);
                            pgStream.send(sm3Digest);
                            pgStream.sendChar(0);
                            pgStream.flush();
                            if (!log.isLoggable(Level.INFO)) continue block10;
                            log.log(Level.INFO, "The current connection is using SM3 authentication.");
                            break block0;
                        }
                        case 3: {
                            log.log(Level.FINEST, "<=BE AuthenticationReqPassword");
                            log.log(Level.FINEST, " FE=> Password(password=<not shown>)");
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] encodedPassword = password.getBytes("UTF-8");
                            pgStream.sendChar(112);
                            pgStream.sendInteger4(4 + encodedPassword.length + 1);
                            pgStream.send(encodedPassword);
                            pgStream.sendChar(0);
                            pgStream.flush();
                            break block0;
                        }
                        case 0: {
                            log.log(Level.FINEST, " <=BE AuthenticationOk");
                            break block10;
                        }
                        default: {
                            log.log(Level.FINEST, " <=BE AuthenticationReq (unsupported type {0})", areq);
                            throw new PSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", areq), PSQLState.CONNECTION_REJECTED);
                        }
                    }
                }
                default: {
                    throw new PSQLException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
                }
            }
        }
    }

    private void runInitialQueries(QueryExecutor queryExecutor, Properties info) throws SQLException {
        String appName;
        String assumeMinServerVersion = PGProperty.ASSUME_MIN_SERVER_VERSION.get(info);
        if (Utils.parseServerVersionStr(assumeMinServerVersion) >= ServerVersion.v9_0.getVersionNum()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("\u65e0\u9700\u6267\u884c runInitialQueries");
            }
            return;
        }
        int dbVersion = queryExecutor.getServerVersionNum();
        if (dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("SET extra_float_digits = 3");
            }
            SetupQueryRunner.run(queryExecutor, "SET extra_float_digits = 3", false);
        }
        if ((appName = PGProperty.APPLICATION_NAME.get(info)) != null && dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("SET application_name = " + appName);
            }
            StringBuilder sql = new StringBuilder();
            sql.append("SET application_name = '");
            Utils.escapeLiteral(sql, appName, queryExecutor.getStandardConformingStrings());
            sql.append("'");
            SetupQueryRunner.run(queryExecutor, sql.toString(), false);
        }
    }

    private boolean isPrimary(QueryExecutor queryExecutor) throws SQLException, IOException {
        Tuple results = SetupQueryRunner.run(queryExecutor, "show transaction_read_only", true);
        Tuple nonNullResults = Nullness.castNonNull(results);
        String value = queryExecutor.getEncoding().decode(Nullness.castNonNull(nonNullResults.get(0)));
        return value.equalsIgnoreCase("off");
    }
}

