/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.v3.replication;

import com.hundsun.lightdb.copy.CopyDual;
import com.hundsun.lightdb.core.PGStream;
import com.hundsun.lightdb.core.QueryExecutor;
import com.hundsun.lightdb.core.ReplicationProtocol;
import com.hundsun.lightdb.core.v3.replication.V3PGReplicationStream;
import com.hundsun.lightdb.replication.PGReplicationStream;
import com.hundsun.lightdb.replication.ReplicationType;
import com.hundsun.lightdb.replication.fluent.CommonOptions;
import com.hundsun.lightdb.replication.fluent.logical.LogicalReplicationOptions;
import com.hundsun.lightdb.replication.fluent.physical.PhysicalReplicationOptions;
import com.hundsun.lightdb.util.GT;
import com.hundsun.lightdb.util.PSQLException;
import com.hundsun.lightdb.util.PSQLState;
import com.hundsun.lightdb.util.internal.Nullness;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class V3ReplicationProtocol
implements ReplicationProtocol {
    private static final Logger log = Logger.getLogger(V3ReplicationProtocol.class.getName());
    private final QueryExecutor queryExecutor;
    private final PGStream pgStream;

    public V3ReplicationProtocol(QueryExecutor queryExecutor, PGStream pgStream) {
        this.queryExecutor = queryExecutor;
        this.pgStream = pgStream;
    }

    @Override
    public PGReplicationStream startLogical(LogicalReplicationOptions options) throws SQLException {
        String query = this.createStartLogicalQuery(options);
        return this.initializeReplication(query, options, ReplicationType.LOGICAL);
    }

    @Override
    public PGReplicationStream startPhysical(PhysicalReplicationOptions options) throws SQLException {
        String query = this.createStartPhysicalQuery(options);
        return this.initializeReplication(query, options, ReplicationType.PHYSICAL);
    }

    private PGReplicationStream initializeReplication(String query, CommonOptions options, ReplicationType replicationType) throws SQLException {
        log.log(Level.FINEST, " FE=> StartReplication(query: {0})", query);
        this.configureSocketTimeout(options);
        CopyDual copyDual = (CopyDual)this.queryExecutor.startCopy(query, true);
        return new V3PGReplicationStream(Nullness.castNonNull(copyDual), options.getStartLSNPosition(), options.getStatusInterval(), replicationType);
    }

    private String createStartPhysicalQuery(PhysicalReplicationOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("START_REPLICATION");
        if (options.getSlotName() != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("createStartPhysicalQuery SLOT: " + options.getSlotName());
            }
            builder.append(" SLOT ").append(options.getSlotName());
        }
        builder.append(" PHYSICAL ").append(options.getStartLSNPosition().asString());
        return builder.toString();
    }

    private String createStartLogicalQuery(LogicalReplicationOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("START_REPLICATION SLOT ").append(options.getSlotName()).append(" LOGICAL ").append(options.getStartLSNPosition().asString());
        Properties slotOptions = options.getSlotOptions();
        if (slotOptions.isEmpty()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("slotOptions \u4e3a\u7a7a");
            }
            return builder.toString();
        }
        builder.append(" (");
        boolean isFirst = true;
        for (String name : slotOptions.stringPropertyNames()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append('\"').append(name).append('\"').append(" ").append('\'').append(slotOptions.getProperty(name)).append('\'');
        }
        builder.append(")");
        return builder.toString();
    }

    private void configureSocketTimeout(CommonOptions options) throws PSQLException {
        if (options.getStatusInterval() == 0) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("getStatusInterval \u4e3a 0");
            }
            return;
        }
        try {
            int minimalTimeOut;
            int previousTimeOut = this.pgStream.getSocket().getSoTimeout();
            if (previousTimeOut > 0) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("previousTimeOut > 0");
                }
                minimalTimeOut = Math.min(previousTimeOut, options.getStatusInterval());
            } else {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("previousTimeOut <= 0");
                }
                minimalTimeOut = options.getStatusInterval();
            }
            this.pgStream.getSocket().setSoTimeout(minimalTimeOut);
            this.pgStream.setMinStreamAvailableCheckDelay(0);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("The connection attempt failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
    }
}

