/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ds.common;

import com.hundsun.lightdb.ds.PGConnectionPoolDataSource;
import com.hundsun.lightdb.ds.PGPoolingDataSource;
import com.hundsun.lightdb.ds.PGSimpleDataSource;
import com.hundsun.lightdb.ds.common.BaseDataSource;
import com.hundsun.lightdb.util.internal.Nullness;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class PGObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String className = ref.getClassName();
        if (className.equals("com.hundsun.lightdb.ds.PGSimpleDataSource") || className.equals("com.hundsun.lightdb.jdbc2.optional.SimpleDataSource") || className.equals("com.hundsun.lightdb.jdbc3.Jdbc3SimpleDataSource")) {
            return this.loadSimpleDataSource(ref);
        }
        if (className.equals("com.hundsun.lightdb.ds.PGConnectionPoolDataSource") || className.equals("com.hundsun.lightdb.jdbc2.optional.ConnectionPool") || className.equals("com.hundsun.lightdb.jdbc3.Jdbc3ConnectionPool")) {
            return this.loadConnectionPool(ref);
        }
        if (className.equals("com.hundsun.lightdb.ds.PGPoolingDataSource") || className.equals("com.hundsun.lightdb.jdbc2.optional.PoolingDataSource") || className.equals("com.hundsun.lightdb.jdbc3.Jdbc3PoolingDataSource")) {
            return this.loadPoolingDataSource(ref);
        }
        return null;
    }

    private Object loadPoolingDataSource(Reference ref) {
        String max;
        String name = Nullness.castNonNull(this.getProperty(ref, "dataSourceName"));
        PGPoolingDataSource pds = PGPoolingDataSource.getDataSource(name);
        if (pds != null) {
            return pds;
        }
        pds = new PGPoolingDataSource();
        pds.setDataSourceName(name);
        this.loadBaseDataSource(pds, ref);
        String min = this.getProperty(ref, "initialConnections");
        if (min != null) {
            pds.setInitialConnections(Integer.parseInt(min));
        }
        if ((max = this.getProperty(ref, "maxConnections")) != null) {
            pds.setMaxConnections(Integer.parseInt(max));
        }
        return pds;
    }

    private Object loadSimpleDataSource(Reference ref) {
        PGSimpleDataSource ds = new PGSimpleDataSource();
        return this.loadBaseDataSource(ds, ref);
    }

    private Object loadConnectionPool(Reference ref) {
        PGConnectionPoolDataSource cp = new PGConnectionPoolDataSource();
        return this.loadBaseDataSource(cp, ref);
    }

    protected Object loadBaseDataSource(BaseDataSource ds, Reference ref) {
        ds.setFromReference(ref);
        return ds;
    }

    protected String getProperty(Reference ref, String s) {
        RefAddr addr = ref.get(s);
        if (addr == null) {
            return null;
        }
        return (String)addr.getContent();
    }
}

