/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.replication;

import com.hundsun.lightdb.core.BaseConnection;
import com.hundsun.lightdb.replication.PGReplicationConnection;
import com.hundsun.lightdb.replication.fluent.ChainedCreateReplicationSlotBuilder;
import com.hundsun.lightdb.replication.fluent.ChainedStreamBuilder;
import com.hundsun.lightdb.replication.fluent.ReplicationCreateSlotBuilder;
import com.hundsun.lightdb.replication.fluent.ReplicationStreamBuilder;
import java.sql.SQLException;
import java.sql.Statement;

public class PGReplicationConnectionImpl
implements PGReplicationConnection {
    private BaseConnection connection;

    public PGReplicationConnectionImpl(BaseConnection connection) {
        this.connection = connection;
    }

    @Override
    public ChainedStreamBuilder replicationStream() {
        return new ReplicationStreamBuilder(this.connection);
    }

    @Override
    public ChainedCreateReplicationSlotBuilder createReplicationSlot() {
        return new ReplicationCreateSlotBuilder(this.connection);
    }

    @Override
    public void dropReplicationSlot(String slotName) throws SQLException {
        if (slotName == null || slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slot name can't be null or empty");
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute("DROP_REPLICATION_SLOT " + slotName);
        }
    }
}

