/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid;

import com.hundsun.lightdb.shaded.com.alibaba.druid.util.FnvHash;

public enum DbType {
    other(1L),
    jtds(2L),
    hsql(4L),
    db2(8L),
    postgresql(16L),
    sqlserver(32L),
    oracle(64L),
    mysql(128L),
    mariadb(256L),
    derby(512L),
    hive(1024L),
    h2(2048L),
    dm(4096L),
    kingbase(8192L),
    gbase(16384L),
    oceanbase(32768L),
    informix(65536L),
    odps(131072L),
    teradata(262144L),
    phoenix(524288L),
    edb(0x100000L),
    kylin(0x200000L),
    sqlite(0x400000L),
    ads(0x800000L),
    presto(0x1000000L),
    elastic_search(0x2000000L),
    hbase(0x4000000L),
    drds(0x8000000L),
    clickhouse(0x10000000L),
    blink(0x20000000L),
    antspark(0x40000000L),
    oceanbase_oracle(Integer.MIN_VALUE),
    polardb(0x100000000L),
    ali_oracle(0x200000000L),
    mock(0x400000000L),
    sybase(0x800000000L),
    highgo(0x1000000000L),
    greenplum(0x2000000000L),
    gaussdb(0x4000000000L),
    trino(0x8000000000L),
    oscar(0x10000000000L),
    tidb(0x20000000000L),
    tydb(0x40000000000L),
    ingres(0L),
    cloudscape(0L),
    timesten(0L),
    as400(0L),
    sapdb(0L),
    kdb(0L),
    log4jdbc(0L),
    xugu(0L),
    firebirdsql(0L),
    JSQLConnect(0L),
    JTurbo(0L),
    interbase(0L),
    pointbase(0L),
    edbc(0L),
    mimer(0L);

    public final long mask;
    public final long hashCode64;

    private DbType(long mask) {
        this.mask = mask;
        this.hashCode64 = FnvHash.hashCode64(this.name());
    }

    public static long of(DbType ... types) {
        long value = 0L;
        for (DbType type : types) {
            value |= type.mask;
        }
        return value;
    }

    public static DbType of(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        if ("aliyun_ads".equalsIgnoreCase(name)) {
            return ads;
        }
        try {
            return DbType.valueOf(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final boolean equals(String other) {
        return this == DbType.of(other);
    }
}

