/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.pool.ha;

import com.hundsun.lightdb.shaded.com.alibaba.druid.support.logging.Log;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.logging.LogFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class PropertiesUtils {
    private static final Log LOG = LogFactory.getLog(PropertiesUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String file) {
        Properties properties = new Properties();
        if (file == null) {
            return properties;
        }
        InputStream is = null;
        try {
            LOG.debug("Trying to load " + file + " from FileSystem.");
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            LOG.debug("Trying to load " + file + " from Classpath.");
            try {
                is = PropertiesUtils.class.getResourceAsStream(file);
            }
            catch (Exception ex) {
                LOG.warn("Can not load resource " + file, ex);
            }
        }
        if (is != null) {
            try {
                properties.load(is);
            }
            catch (Exception e) {
                LOG.error("Exception occurred while loading " + file, e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        LOG.debug("Can not close Inputstream.", e);
                    }
                }
            }
        } else {
            LOG.warn("File " + file + " can't be loaded!");
        }
        return properties;
    }

    public static List<String> loadNameList(Properties properties, String propertyPrefix) {
        ArrayList<String> nameList = new ArrayList<String>();
        HashSet<String> names = new HashSet<String>();
        for (String n : properties.stringPropertyNames()) {
            if (propertyPrefix != null && !propertyPrefix.isEmpty() && !n.startsWith(propertyPrefix) || !n.endsWith(".url")) continue;
            names.add(n.split("\\.url")[0]);
        }
        if (!names.isEmpty()) {
            nameList.addAll(names);
        }
        return nameList;
    }

    public static Properties filterPrefix(Properties properties, String prefix) {
        if (properties == null || prefix == null || prefix.isEmpty()) {
            return properties;
        }
        Properties result = new Properties();
        for (String n : properties.stringPropertyNames()) {
            if (!n.startsWith(prefix)) continue;
            result.setProperty(n, properties.getProperty(n));
        }
        return result;
    }
}

