/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.pool.ha.node;

import com.hundsun.lightdb.shaded.com.alibaba.druid.pool.DruidDataSource;
import com.hundsun.lightdb.shaded.com.alibaba.druid.pool.ha.DataSourceCreator;
import com.hundsun.lightdb.shaded.com.alibaba.druid.pool.ha.HighAvailableDataSource;
import com.hundsun.lightdb.shaded.com.alibaba.druid.pool.ha.node.NodeEvent;
import com.hundsun.lightdb.shaded.com.alibaba.druid.pool.ha.node.NodeEventTypeEnum;
import com.hundsun.lightdb.shaded.com.alibaba.druid.pool.ha.node.NodeListener;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.logging.Log;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.logging.LogFactory;
import com.hundsun.lightdb.shaded.com.alibaba.druid.util.JdbcUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;

public class PoolUpdater
implements Observer {
    public static final int DEFAULT_INTERVAL = 60;
    private static final Log LOG = LogFactory.getLog(PoolUpdater.class);
    private Set<String> nodesToDel = new CopyOnWriteArraySet<String>();
    private HighAvailableDataSource highAvailableDataSource;
    private Lock lock = new ReentrantLock();
    private ScheduledExecutorService executor;
    private int intervalSeconds = 60;
    private volatile boolean inited;
    private boolean allowEmptyPool;

    public PoolUpdater(HighAvailableDataSource highAvailableDataSource) {
        this.setHighAvailableDataSource(highAvailableDataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.inited) {
            return;
        }
        PoolUpdater poolUpdater = this;
        synchronized (poolUpdater) {
            if (this.inited) {
                return;
            }
            if (this.intervalSeconds < 10) {
                LOG.warn("CAUTION: Purge interval has been set to " + this.intervalSeconds + ". This value should NOT be too small.");
            }
            if (this.intervalSeconds <= 0) {
                this.intervalSeconds = 60;
            }
            this.executor = Executors.newScheduledThreadPool(1);
            this.executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    LOG.debug("Purging the DataSource Pool every " + PoolUpdater.this.intervalSeconds + "s.");
                    try {
                        PoolUpdater.this.removeDataSources();
                    }
                    catch (Exception e) {
                        LOG.error("Exception occurred while removing DataSources.", e);
                    }
                }
            }, this.intervalSeconds, this.intervalSeconds, TimeUnit.SECONDS);
        }
    }

    public void destroy() {
        if (this.executor == null || this.executor.isShutdown()) {
            return;
        }
        try {
            this.executor.shutdown();
        }
        catch (Exception e) {
            LOG.error("Can NOT shutdown the ScheduledExecutorService.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        if (!(o instanceof NodeListener)) {
            return;
        }
        if (arg == null || !(arg instanceof NodeEvent[])) {
            return;
        }
        NodeEvent[] events = (NodeEvent[])arg;
        if (events.length <= 0) {
            return;
        }
        try {
            LOG.info("Waiting for Lock to start processing NodeEvents.");
            this.lock.lock();
            LOG.info("Start processing the NodeEvent[" + events.length + "].");
            for (NodeEvent e : events) {
                if (e.getType() == NodeEventTypeEnum.ADD) {
                    this.addNode(e);
                    continue;
                }
                if (e.getType() != NodeEventTypeEnum.DELETE) continue;
                this.deleteNode(e);
            }
        }
        catch (Exception e) {
            LOG.error("Exception occurred while updating Pool.", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSources() {
        if (this.nodesToDel == null || this.nodesToDel.isEmpty()) {
            return;
        }
        try {
            this.lock.lock();
            Map<String, DataSource> map = this.highAvailableDataSource.getDataSourceMap();
            HashSet<String> copySet = new HashSet<String>(this.nodesToDel);
            for (String nodeName : copySet) {
                LOG.info("Start removing Node " + nodeName + ".");
                if (!map.containsKey(nodeName)) {
                    LOG.info("Node " + nodeName + " is NOT existed in the map.");
                    this.cancelBlacklistNode(nodeName);
                    continue;
                }
                DataSource ds = map.get(nodeName);
                if (ds instanceof DruidDataSource) {
                    DruidDataSource dds = (DruidDataSource)ds;
                    int activeCount = dds.getActiveCount();
                    if (activeCount > 0) {
                        LOG.warn("Node " + nodeName + " is still running [activeCount=" + activeCount + "], try next time.");
                        continue;
                    }
                    LOG.info("Close Node " + nodeName + " and remove it.");
                    try {
                        dds.close();
                    }
                    catch (Exception e) {
                        LOG.error("Exception occurred while closing Node " + nodeName + ", just remove it.", e);
                    }
                }
                map.remove(nodeName);
                this.cancelBlacklistNode(nodeName);
            }
        }
        catch (Exception e) {
            LOG.error("Exception occurred while removing DataSources.", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void addNode(NodeEvent event) {
        String nodeName = event.getNodeName();
        String url = event.getUrl();
        String username = event.getUsername();
        String password = event.getPassword();
        Map<String, DataSource> map = this.highAvailableDataSource.getDataSourceMap();
        if (nodeName == null || nodeName.isEmpty()) {
            return;
        }
        LOG.info("Adding Node " + nodeName + "[url: " + url + ", username: " + username + "].");
        if (map.containsKey(nodeName)) {
            this.cancelBlacklistNode(nodeName);
            return;
        }
        DruidDataSource dataSource = null;
        try {
            dataSource = DataSourceCreator.create(nodeName, url, username, password, this.highAvailableDataSource);
            map.put(nodeName, dataSource);
            LOG.info("Creating Node " + nodeName + "[url: " + url + ", username: " + username + "].");
        }
        catch (Exception e) {
            LOG.error("Can NOT create DataSource " + nodeName + ". IGNORE IT.", e);
            JdbcUtils.close(dataSource);
        }
    }

    protected void deleteNode(NodeEvent event) {
        String nodeName = event.getNodeName();
        Map<String, DataSource> map = this.highAvailableDataSource.getDataSourceMap();
        if (nodeName == null || nodeName.isEmpty() || !map.containsKey(nodeName)) {
            return;
        }
        map = this.highAvailableDataSource.getAvailableDataSourceMap();
        if (!this.allowEmptyPool && map.size() == 1 && map.containsKey(nodeName)) {
            LOG.warn(nodeName + " is the only DataSource left, don't remove it.");
            return;
        }
        this.blacklistNode(nodeName);
    }

    private void cancelBlacklistNode(String nodeName) {
        LOG.info("Cancel the deletion of Node " + nodeName + ".");
        this.nodesToDel.remove(nodeName);
        this.highAvailableDataSource.removeBlackList(nodeName);
    }

    private void blacklistNode(String nodeName) {
        LOG.info("Deleting Node " + nodeName + ", just add it into blacklist.");
        this.nodesToDel.add(nodeName);
        this.highAvailableDataSource.addBlackList(nodeName);
    }

    public HighAvailableDataSource getHighAvailableDataSource() {
        return this.highAvailableDataSource;
    }

    public void setHighAvailableDataSource(HighAvailableDataSource highAvailableDataSource) {
        this.highAvailableDataSource = highAvailableDataSource;
    }

    public Set<String> getNodesToDel() {
        return this.nodesToDel;
    }

    public int getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public void setIntervalSeconds(int intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
    }

    public boolean isAllowEmptyPool() {
        return this.allowEmptyPool;
    }

    public void setAllowEmptyPool(boolean allowEmptyPool) {
        this.allowEmptyPool = allowEmptyPool;
    }
}

