/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.proxy.jdbc;

import com.hundsun.lightdb.shaded.com.alibaba.druid.filter.FilterChain;
import com.hundsun.lightdb.shaded.com.alibaba.druid.filter.FilterChainImpl;
import com.hundsun.lightdb.shaded.com.alibaba.druid.proxy.jdbc.ClobProxy;
import com.hundsun.lightdb.shaded.com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.hundsun.lightdb.shaded.com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobProxyImpl
implements ClobProxy {
    protected final Clob clob;
    protected final ConnectionProxy connection;
    protected final DataSourceProxy dataSource;

    public ClobProxyImpl(DataSourceProxy dataSource, ConnectionProxy connection, Clob clob) {
        if (clob == null) {
            throw new IllegalArgumentException("clob is null");
        }
        this.dataSource = dataSource;
        this.connection = connection;
        this.clob = clob;
    }

    public FilterChain createChain() {
        return new FilterChainImpl(this.dataSource);
    }

    @Override
    public ConnectionProxy getConnectionWrapper() {
        return this.connection;
    }

    @Override
    public Clob getRawClob() {
        return this.clob;
    }

    @Override
    public void free() throws SQLException {
        this.createChain().clob_free(this);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.createChain().clob_getAsciiStream(this);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.createChain().clob_getCharacterStream(this);
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        return this.createChain().clob_getCharacterStream(this, pos, length);
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        return this.createChain().clob_getSubString(this, pos, length);
    }

    @Override
    public long length() throws SQLException {
        return this.createChain().clob_length(this);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        return this.createChain().clob_position((ClobProxy)this, searchstr, start);
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        return this.createChain().clob_position((ClobProxy)this, searchstr, start);
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return this.createChain().clob_setAsciiStream(this, pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        return this.createChain().clob_setCharacterStream(this, pos);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.createChain().clob_setString(this, pos, str);
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        return this.createChain().clob_setString(this, pos, str, offset, len);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.createChain().clob_truncate(this, len);
    }

    public String toString() {
        return this.clob.toString();
    }
}

