/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast;

import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLReplaceable;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public final class SQLOrderBy
extends SQLObjectImpl
implements SQLReplaceable {
    protected final List<SQLSelectOrderByItem> items = new ArrayList<SQLSelectOrderByItem>();
    private boolean siblings;

    public SQLOrderBy() {
    }

    public SQLOrderBy(SQLExpr expr) {
        SQLSelectOrderByItem item = new SQLSelectOrderByItem(expr);
        this.addItem(item);
    }

    public SQLOrderBy(SQLExpr expr, SQLOrderingSpecification type) {
        SQLSelectOrderByItem item = new SQLSelectOrderByItem(expr, type);
        this.addItem(item);
    }

    public void addItem(SQLSelectOrderByItem item) {
        if (item != null) {
            item.setParent(this);
        }
        this.items.add(item);
    }

    public void addItem(SQLExpr item) {
        this.addItem(new SQLSelectOrderByItem(item));
    }

    public List<SQLSelectOrderByItem> getItems() {
        return this.items;
    }

    public boolean isSiblings() {
        return this.siblings;
    }

    public void setSiblings(boolean siblings) {
        this.siblings = siblings;
    }

    @Override
    protected void accept0(SQLASTVisitor v) {
        if (v.visit(this)) {
            for (int i = 0; i < this.items.size(); ++i) {
                SQLSelectOrderByItem item = this.items.get(i);
                item.accept(v);
            }
        }
        v.endVisit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLOrderBy order = (SQLOrderBy)o;
        if (this.siblings != order.siblings) {
            return false;
        }
        return this.items.equals(order.items);
    }

    public int hashCode() {
        int result = this.items.hashCode();
        result = 31 * result + (this.siblings ? 1 : 0);
        return result;
    }

    public void addItem(SQLExpr expr, SQLOrderingSpecification type) {
        SQLSelectOrderByItem item = this.createItem();
        item.setExpr(expr);
        item.setType(type);
        this.addItem(item);
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        for (SQLSelectOrderByItem item : this.items) {
            if (!item.replace(expr, target)) continue;
            return true;
        }
        return false;
    }

    protected SQLSelectOrderByItem createItem() {
        return new SQLSelectOrderByItem();
    }

    @Override
    public SQLOrderBy clone() {
        SQLOrderBy x = new SQLOrderBy();
        for (SQLSelectOrderByItem item : this.items) {
            SQLSelectOrderByItem item1 = item.clone();
            item1.setParent(x);
            x.items.add(item1);
        }
        x.siblings = this.siblings;
        return x;
    }
}

