/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast;

import com.hundsun.lightdb.shaded.com.alibaba.druid.DbType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLDataType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLName;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.hundsun.lightdb.shaded.com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SQLStructDataType
extends SQLObjectImpl
implements SQLDataType {
    private DbType dbType;
    private List<Field> fields = new ArrayList<Field>();

    public SQLStructDataType() {
    }

    public SQLStructDataType(DbType dbType) {
        this.dbType = dbType;
    }

    @Override
    public String getName() {
        return "STRUCT";
    }

    @Override
    public long nameHashCode64() {
        return FnvHash.Constants.STRUCT;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SQLExpr> getArguments() {
        return Collections.emptyList();
    }

    @Override
    public Boolean getWithTimeZone() {
        return null;
    }

    @Override
    public void setWithTimeZone(Boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWithLocalTimeZone() {
        return false;
    }

    @Override
    public void setWithLocalTimeZone(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    @Override
    public DbType getDbType() {
        return this.dbType;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.fields);
        }
        visitor.endVisit(this);
    }

    @Override
    public SQLStructDataType clone() {
        SQLStructDataType x = new SQLStructDataType(this.dbType);
        for (Field field : this.fields) {
            x.addField(field.name, field.dataType.clone());
        }
        return x;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public Field addField(SQLName name, SQLDataType dataType) {
        Field field = new Field(name, dataType);
        field.setParent(this);
        this.fields.add(field);
        return field;
    }

    @Override
    public int jdbcType() {
        return 2002;
    }

    @Override
    public boolean isInt() {
        return false;
    }

    @Override
    public boolean isNumberic() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean hasKeyLength() {
        return false;
    }

    public static class Field
    extends SQLObjectImpl {
        private SQLName name;
        private SQLDataType dataType;
        private String comment;

        public Field(SQLName name, SQLDataType dataType) {
            this.setName(name);
            this.setDataType(dataType);
        }

        @Override
        protected void accept0(SQLASTVisitor visitor) {
            if (visitor.visit(this)) {
                this.acceptChild(visitor, this.name);
                this.acceptChild(visitor, this.dataType);
            }
            visitor.endVisit(this);
        }

        public SQLName getName() {
            return this.name;
        }

        public void setName(SQLName x) {
            if (x != null) {
                x.setParent(this);
            }
            this.name = x;
        }

        public SQLDataType getDataType() {
            return this.dataType;
        }

        public void setDataType(SQLDataType x) {
            if (x != null) {
                x.setParent(this);
            }
            this.dataType = x;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }
}

