/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr;

import com.hundsun.lightdb.shaded.com.alibaba.druid.FastsqlException;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLDataType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExprImpl;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class SQLBooleanExpr
extends SQLExprImpl
implements SQLExpr,
SQLLiteralExpr,
SQLValuableExpr {
    public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("BOOLEAN");
    private boolean value;

    public SQLBooleanExpr() {
    }

    public SQLBooleanExpr(boolean value) {
        this.value = value;
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public void output(Appendable buf) {
        try {
            buf.append(this.value ? "true" : "false");
        }
        catch (IOException ex) {
            throw new FastsqlException("output error", ex);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLBooleanExpr other = (SQLBooleanExpr)obj;
        return this.value == other.value;
    }

    @Override
    public SQLDataType computeDataType() {
        return DATA_TYPE;
    }

    @Override
    public SQLBooleanExpr clone() {
        return new SQLBooleanExpr(this.value);
    }

    public List getChildren() {
        return Collections.emptyList();
    }

    public static enum Type {
        ON_OFF;

    }
}

