/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr;

import com.hundsun.lightdb.shaded.com.alibaba.druid.DbType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLDataType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExprImpl;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLReplaceable;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.hundsun.lightdb.shaded.com.alibaba.druid.util.MySqlUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class SQLDateExpr
extends SQLExprImpl
implements SQLLiteralExpr,
SQLValuableExpr,
SQLReplaceable {
    public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("date");
    private String literal;
    public static long supportDbTypes = DbType.of(DbType.mysql, DbType.oracle, DbType.presto, DbType.trino, DbType.postgresql, DbType.ads, DbType.hive, DbType.odps, DbType.mariadb, DbType.tidb);

    public SQLDateExpr() {
    }

    public SQLDateExpr(String literal) {
        this.setLiteral(literal);
    }

    public SQLDateExpr(Date literal) {
        this.setLiteral(literal);
    }

    public SQLDateExpr(Date literal, TimeZone timeZone) {
        this.setLiteral(literal, timeZone);
    }

    public String getLiteral() {
        return this.literal;
    }

    public void setLiteral(String literal) {
        this.literal = literal;
    }

    public void setLiteral(Date x) {
        this.setLiteral(x, null);
    }

    public void setLiteral(Date x, TimeZone timeZone) {
        if (x == null) {
            this.literal = null;
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        }
        String text = format.format(x);
        this.setLiteral(text);
    }

    @Override
    public String getValue() {
        return this.literal;
    }

    public Date getDate() {
        return this.getDate(null);
    }

    public Date getDate(TimeZone timeZone) {
        return MySqlUtils.parseDate(this.literal, timeZone);
    }

    public boolean addDay(int delta) {
        if (this.literal == null) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = format.parse(this.literal);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, delta);
            String result_chars = format.format(calendar.getTime());
            this.setLiteral(result_chars);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public boolean addMonth(int delta) {
        if (this.literal == null) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = format.parse(this.literal);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(2, delta);
            String result_chars = format.format(calendar.getTime());
            this.setLiteral(result_chars);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public boolean addYear(int delta) {
        if (this.literal == null) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = format.parse(this.literal);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(1, delta);
            String result_chars = format.format(calendar.getTime());
            this.setLiteral(result_chars);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLDateExpr other = (SQLDateExpr)obj;
        return !(this.literal == null ? other.literal != null : !this.literal.equals(other.literal));
    }

    @Override
    public SQLDateExpr clone() {
        SQLDateExpr x = new SQLDateExpr();
        if (this.literal != null) {
            x.setLiteral(this.literal);
        }
        return x;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        return false;
    }

    @Override
    public List<SQLObject> getChildren() {
        return Collections.emptyList();
    }

    public static boolean isSupport(DbType dbType) {
        return (dbType.mask & supportDbTypes) != 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean check(String str) {
        int day;
        int month;
        int len;
        if (str == null || (len = str.length()) < 8) {
            return false;
        }
        char c0 = str.charAt(0);
        char c1 = str.charAt(1);
        char c2 = str.charAt(2);
        char c3 = str.charAt(3);
        char c4 = str.charAt(4);
        char c5 = str.charAt(5);
        char c6 = str.charAt(6);
        char c7 = str.charAt(7);
        if (c0 < '1' | c0 > '9') {
            return false;
        }
        if (c1 < '0' | c1 > '9') {
            return false;
        }
        if (c2 < '0' | c2 > '9') {
            return false;
        }
        if (c3 < '0' | c3 > '9') {
            return false;
        }
        int year = (c0 - 48) * 1000 + (c1 - 48) * 100 + (c2 - 48) * 10 + (c3 - 48);
        if (year < 1000) {
            return false;
        }
        if (c4 != '-') {
            return false;
        }
        if (c5 < '0' | c5 > '9') {
            return false;
        }
        if (c6 == '-') {
            month = c5 - 48;
            if (c7 < '0' | c7 > '9') {
                return false;
            }
            if (len == 8) {
                day = c7 - 48;
            } else {
                if (len != 9) return false;
                char c8 = str.charAt(8);
                if (c8 < '0' | c8 > '9') {
                    return false;
                }
                day = (c7 - 48) * 10 + (c8 - 48);
            }
        } else {
            if (c6 < '0' | c6 > '9') {
                return false;
            }
            month = (c5 - 48) * 10 + (c6 - 48);
            if (c7 != '-') {
                return false;
            }
            if (len == 9) {
                char c8 = str.charAt(8);
                if (c8 < '0' | c8 > '9') {
                    return false;
                }
                day = c8 - 48;
            } else {
                if (len != 10) return false;
                char c8 = str.charAt(8);
                char c9 = str.charAt(9);
                if (c8 < '0' | c8 > '9') {
                    return false;
                }
                if (c9 < '0' | c9 > '9') {
                    return false;
                }
                day = (c8 - 48) * 10 + (c9 - 48);
            }
        }
        if (month < 1) {
            return false;
        }
        if (day < 1) {
            return false;
        }
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return day <= 31;
            }
            case 2: {
                return day <= 29;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return day <= 30;
            }
        }
        return false;
    }

    public static String format(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int dayOfMonth = calendar.get(5);
        char[] chars = new char[]{(char)(year / 1000 + 48), (char)(year / 100 % 10 + 48), (char)(year / 10 % 10 + 48), (char)(year % 10 + 48), '-', (char)(month / 10 + 48), (char)(month % 10 + 48), '-', (char)(dayOfMonth / 10 + 48), (char)(dayOfMonth % 10 + 48)};
        return new String(chars);
    }

    @Override
    public SQLDataType computeDataType() {
        return DATA_TYPE;
    }
}

