/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr;

import com.hundsun.lightdb.shaded.com.alibaba.druid.FastsqlException;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.SQLUtils;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLDataType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExprImpl;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLReplaceable;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLDateExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLTimeExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.hundsun.lightdb.shaded.com.alibaba.druid.util.FnvHash;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SQLMethodInvokeExpr
extends SQLExprImpl
implements SQLReplaceable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final List<SQLExpr> arguments = new ArrayList<SQLExpr>();
    protected String methodName;
    protected long methodNameHashCode64;
    protected SQLExpr owner;
    protected SQLExpr from;
    protected SQLExpr using;
    protected SQLExpr hasFor;
    protected String trimOption;
    protected transient SQLDataType resolvedReturnDataType;

    public SQLMethodInvokeExpr() {
    }

    public SQLMethodInvokeExpr(String methodName) {
        this.methodName = methodName;
    }

    public SQLMethodInvokeExpr(String methodName, long methodNameHashCode64) {
        this.methodName = methodName;
        this.methodNameHashCode64 = methodNameHashCode64;
    }

    public SQLMethodInvokeExpr(String methodName, SQLExpr owner) {
        this.methodName = methodName;
        this.setOwner(owner);
    }

    public SQLMethodInvokeExpr(String methodName, SQLExpr owner, SQLExpr ... params) {
        this.methodName = methodName;
        this.setOwner(owner);
        for (SQLExpr param : params) {
            this.addArgument(param);
        }
    }

    public SQLMethodInvokeExpr(String methodName, SQLExpr owner, List<SQLExpr> params) {
        this.methodName = methodName;
        this.setOwner(owner);
        for (SQLExpr param : params) {
            this.addArgument(param);
        }
    }

    public long methodNameHashCode64() {
        if (this.methodNameHashCode64 == 0L && this.methodName != null) {
            this.methodNameHashCode64 = FnvHash.hashCode64(this.methodName);
        }
        return this.methodNameHashCode64;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
        this.methodNameHashCode64 = 0L;
    }

    public List<SQLExpr> getParameters() {
        return this.arguments;
    }

    public List<SQLExpr> getArguments() {
        return this.arguments;
    }

    public void setArgument(int i, SQLExpr arg) {
        if (arg != null) {
            arg.setParent(this);
        }
        this.arguments.set(i, arg);
    }

    public void addParameter(SQLExpr param) {
        if (param != null) {
            param.setParent(this);
        }
        this.arguments.add(param);
    }

    public void addArgument(SQLExpr arg) {
        if (arg != null) {
            arg.setParent(this);
        }
        this.arguments.add(arg);
    }

    public SQLExpr getOwner() {
        return this.owner;
    }

    public void setOwner(SQLExpr owner) {
        if (owner != null) {
            owner.setParent(this);
        }
        this.owner = owner;
    }

    public SQLExpr getFrom() {
        return this.from;
    }

    public void setFrom(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.from = x;
    }

    @Override
    public void output(Appendable buf) {
        try {
            if (this.owner != null) {
                this.owner.output(buf);
                buf.append(".");
            }
            buf.append(this.methodName);
            buf.append("(");
            int size = this.arguments.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    buf.append(", ");
                }
                this.arguments.get(i).output(buf);
            }
            buf.append(")");
        }
        catch (IOException ex) {
            throw new FastsqlException("output error", ex);
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.owner != null) {
                this.owner.accept(visitor);
            }
            for (SQLExpr arg : this.arguments) {
                if (arg == null) continue;
                arg.accept(visitor);
            }
            if (this.from != null) {
                this.from.accept(visitor);
            }
            if (this.using != null) {
                this.using.accept(visitor);
            }
            if (this.hasFor != null) {
                this.hasFor.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public List getChildren() {
        if (this.owner == null) {
            return this.arguments;
        }
        ArrayList<SQLExpr> children = new ArrayList<SQLExpr>();
        children.add(this.owner);
        children.addAll(this.arguments);
        return children;
    }

    protected void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.owner != null) {
                this.owner.accept(visitor);
            }
            for (SQLExpr arg : this.arguments) {
                if (arg == null) continue;
                arg.accept(visitor);
            }
            if (this.from != null) {
                this.from.accept(visitor);
            }
            if (this.using != null) {
                this.using.accept(visitor);
            }
            if (this.hasFor != null) {
                this.hasFor.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLMethodInvokeExpr that = (SQLMethodInvokeExpr)o;
        if (this.methodNameHashCode64() != that.methodNameHashCode64()) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) {
            return false;
        }
        if (!this.arguments.equals(that.arguments)) {
            return false;
        }
        return this.from != null ? this.from.equals(that.from) : that.from == null;
    }

    @Override
    public int hashCode() {
        int result = (int)(this.methodNameHashCode64() ^ this.methodNameHashCode64() >>> 32);
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + this.arguments.hashCode();
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        return result;
    }

    @Override
    public SQLMethodInvokeExpr clone() {
        SQLMethodInvokeExpr x = new SQLMethodInvokeExpr();
        this.cloneTo(x);
        return x;
    }

    public void cloneTo(SQLMethodInvokeExpr x) {
        x.methodName = this.methodName;
        if (this.owner != null) {
            x.setOwner(this.owner.clone());
        }
        for (SQLExpr sQLExpr : this.arguments) {
            x.addArgument(sQLExpr.clone());
        }
        if (this.from != null) {
            x.setFrom(this.from.clone());
        }
        if (this.using != null) {
            x.setUsing(this.using.clone());
        }
        if (this.trimOption != null) {
            x.setTrimOption(this.trimOption);
        }
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof SQLObject) {
                    value = ((SQLObject)value).clone();
                }
                x.putAttribute(key, value);
            }
        }
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (target == null) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i) != expr) continue;
            this.arguments.set(i, target);
            target.setParent(this);
            return true;
        }
        if (this.from == expr) {
            this.setFrom(target);
            return true;
        }
        if (this.using == expr) {
            this.setUsing(target);
            return true;
        }
        if (this.hasFor == expr) {
            this.setFor(target);
            return true;
        }
        return false;
    }

    public boolean match(String owner, String function) {
        if (function == null) {
            return false;
        }
        if (!SQLUtils.nameEquals(function, this.methodName)) {
            return false;
        }
        if (owner == null && this.owner == null) {
            return true;
        }
        if (owner == null || this.owner == null) {
            return false;
        }
        if (this.owner instanceof SQLIdentifierExpr) {
            return SQLUtils.nameEquals(((SQLIdentifierExpr)this.owner).name, owner);
        }
        return false;
    }

    @Override
    public SQLDataType computeDataType() {
        if (this.resolvedReturnDataType != null) {
            return this.resolvedReturnDataType;
        }
        long nameHash = this.methodNameHashCode64();
        if (nameHash == FnvHash.Constants.TO_DATE || nameHash == FnvHash.Constants.ADD_MONTHS) {
            this.resolvedReturnDataType = SQLDateExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.DATE_PARSE) {
            this.resolvedReturnDataType = SQLTimestampExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.CURRENT_TIME || nameHash == FnvHash.Constants.CURTIME) {
            this.resolvedReturnDataType = SQLTimeExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.BIT_COUNT || nameHash == FnvHash.Constants.ROW_NUMBER) {
            this.resolvedReturnDataType = new SQLDataTypeImpl("BIGINT");
            return this.resolvedReturnDataType;
        }
        if (this.arguments.size() == 1) {
            if (nameHash == FnvHash.Constants.TRUNC) {
                this.resolvedReturnDataType = this.arguments.get(0).computeDataType();
                return this.resolvedReturnDataType;
            }
        } else if (this.arguments.size() == 2) {
            SQLExpr param0 = this.arguments.get(0);
            SQLExpr param1 = this.arguments.get(1);
            if (nameHash == FnvHash.Constants.ROUND) {
                SQLDataType dataType = param0.computeDataType();
                if (dataType != null) {
                    return dataType;
                }
            } else if (nameHash == FnvHash.Constants.NVL || nameHash == FnvHash.Constants.IFNULL || nameHash == FnvHash.Constants.ISNULL || nameHash == FnvHash.Constants.COALESCE) {
                SQLDataType dataType = param0.computeDataType();
                if (dataType != null) {
                    return dataType;
                }
                return param1.computeDataType();
            }
            if (nameHash == FnvHash.Constants.MOD) {
                this.resolvedReturnDataType = SQLIntegerExpr.DATA_TYPE;
                return this.resolvedReturnDataType;
            }
        }
        if (nameHash == FnvHash.Constants.STDDEV_SAMP) {
            this.resolvedReturnDataType = SQLNumberExpr.DATA_TYPE_DOUBLE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.CONCAT || nameHash == FnvHash.Constants.SUBSTR || nameHash == FnvHash.Constants.SUBSTRING) {
            this.resolvedReturnDataType = SQLCharExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.YEAR || nameHash == FnvHash.Constants.MONTH || nameHash == FnvHash.Constants.DAY || nameHash == FnvHash.Constants.HOUR || nameHash == FnvHash.Constants.MINUTE || nameHash == FnvHash.Constants.SECOND || nameHash == FnvHash.Constants.PERIOD_ADD || nameHash == FnvHash.Constants.PERIOD_DIFF) {
            this.resolvedReturnDataType = new SQLDataTypeImpl("INT");
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.GROUPING) {
            this.resolvedReturnDataType = new SQLDataTypeImpl("INT");
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.JSON_EXTRACT_SCALAR || nameHash == FnvHash.Constants.FORMAT_DATETIME || nameHash == FnvHash.Constants.DATE_FORMAT) {
            this.resolvedReturnDataType = SQLCharExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.DATE_ADD || nameHash == FnvHash.Constants.DATE_SUB || nameHash == FnvHash.Constants.DATE || nameHash == FnvHash.Constants.STR_TO_DATE || nameHash == FnvHash.Constants.CURRENT_DATE) {
            this.resolvedReturnDataType = SQLDateExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.UNIX_TIMESTAMP) {
            this.resolvedReturnDataType = SQLIntegerExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.TIME) {
            this.resolvedReturnDataType = new SQLDataTypeImpl("VARCHAR");
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.SYSDATE || nameHash == FnvHash.Constants.CURRENT_TIMESTAMP || nameHash == FnvHash.Constants.SYSTIMESTAMP) {
            this.resolvedReturnDataType = SQLTimestampExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        return null;
    }

    public SQLExpr getUsing() {
        return this.using;
    }

    public void setUsing(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.using = x;
    }

    public SQLExpr getFor() {
        return this.hasFor;
    }

    public void setFor(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.hasFor = x;
    }

    public String getTrimOption() {
        return this.trimOption;
    }

    public void setTrimOption(String trimOption) {
        this.trimOption = trimOption;
    }

    public SQLDataType getResolvedReturnDataType() {
        return this.resolvedReturnDataType;
    }

    public void setResolvedReturnDataType(SQLDataType resolvedReturnDataType) {
        this.resolvedReturnDataType = resolvedReturnDataType;
    }
}

