/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr;

import com.hundsun.lightdb.shaded.com.alibaba.druid.FastsqlException;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLDataType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLTextLiteralExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLCharacterDataType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;

public class SQLNCharExpr
extends SQLTextLiteralExpr {
    private static SQLDataType defaultDataType = new SQLCharacterDataType("nvarchar");

    public SQLNCharExpr() {
    }

    public SQLNCharExpr(String text) {
        this.text = text;
    }

    public SQLNCharExpr(String text, SQLObject parent) {
        this.text = text;
        this.parent = parent;
    }

    @Override
    public void output(Appendable buf) {
        try {
            if (this.text == null || this.text.length() == 0) {
                buf.append("NULL");
                return;
            }
            buf.append("N'");
            buf.append(this.text.replaceAll("'", "''"));
            buf.append("'");
        }
        catch (IOException ex) {
            throw new FastsqlException("output error", ex);
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public SQLNCharExpr clone() {
        return new SQLNCharExpr(this.text);
    }

    @Override
    public SQLDataType computeDataType() {
        return defaultDataType;
    }
}

