/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr;

import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLTinyIntExpr
extends SQLNumericLiteralExpr
implements SQLValuableExpr {
    private Byte value;

    public SQLTinyIntExpr() {
    }

    public SQLTinyIntExpr(Byte value) {
        this.value = value;
    }

    public SQLTinyIntExpr(String value) {
        if (value.startsWith("--")) {
            value = value.substring(2);
        }
        this.value = Byte.valueOf(value);
    }

    @Override
    public SQLTinyIntExpr clone() {
        return new SQLTinyIntExpr(this.value);
    }

    @Override
    public List<SQLObject> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Number getNumber() {
        return this.value;
    }

    @Override
    public Byte getValue() {
        return this.value;
    }

    public void setValue(Byte value) {
        this.value = value;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLTinyIntExpr other = (SQLTinyIntExpr)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public void setNumber(Number number) {
        if (number == null) {
            this.setValue(null);
            return;
        }
        this.setValue((Byte)number);
    }
}

