/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement;

import com.hundsun.lightdb.shaded.com.alibaba.druid.DbType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLName;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLAlterStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAlterTableStatement
extends SQLStatementImpl
implements SQLDDLStatement,
SQLAlterStatement {
    private SQLExprTableSource tableSource;
    private List<SQLAlterTableItem> items = new ArrayList<SQLAlterTableItem>();
    private boolean ignore;
    private boolean online;
    private boolean offline;
    private boolean updateGlobalIndexes;
    private boolean invalidateGlobalIndexes;
    private boolean removePatiting;
    private boolean upgradePatiting;
    private List<SQLAssignItem> tableOptions = new ArrayList<SQLAssignItem>();
    private SQLPartitionBy partition;
    private boolean mergeSmallFiles;
    protected boolean range;
    protected final List<SQLSelectOrderByItem> clusteredBy = new ArrayList<SQLSelectOrderByItem>();
    protected final List<SQLSelectOrderByItem> sortedBy = new ArrayList<SQLSelectOrderByItem>();
    protected int buckets;
    protected int shards;
    private boolean ifExists;
    private boolean notClustered;
    private SQLName on;

    public SQLAlterTableStatement() {
    }

    public SQLAlterTableStatement(DbType dbType) {
        super(dbType);
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public boolean isRemovePatiting() {
        return this.removePatiting;
    }

    public void setRemovePatiting(boolean removePatiting) {
        this.removePatiting = removePatiting;
    }

    public boolean isUpgradePatiting() {
        return this.upgradePatiting;
    }

    public void setUpgradePatiting(boolean upgradePatiting) {
        this.upgradePatiting = upgradePatiting;
    }

    public boolean isUpdateGlobalIndexes() {
        return this.updateGlobalIndexes;
    }

    public void setUpdateGlobalIndexes(boolean updateGlobalIndexes) {
        this.updateGlobalIndexes = updateGlobalIndexes;
    }

    public boolean isInvalidateGlobalIndexes() {
        return this.invalidateGlobalIndexes;
    }

    public void setInvalidateGlobalIndexes(boolean invalidateGlobalIndexes) {
        this.invalidateGlobalIndexes = invalidateGlobalIndexes;
    }

    public boolean isMergeSmallFiles() {
        return this.mergeSmallFiles;
    }

    public void setMergeSmallFiles(boolean mergeSmallFiles) {
        this.mergeSmallFiles = mergeSmallFiles;
    }

    public List<SQLAlterTableItem> getItems() {
        return this.items;
    }

    public void addItem(SQLAlterTableItem item) {
        if (item != null) {
            item.setParent(this);
        }
        this.items.add(item);
    }

    public SQLExprTableSource getTableSource() {
        return this.tableSource;
    }

    public void setTableSource(SQLExprTableSource tableSource) {
        this.tableSource = tableSource;
    }

    public void setTableSource(SQLExpr table) {
        this.setTableSource(new SQLExprTableSource(table));
    }

    public SQLName getName() {
        if (this.getTableSource() == null) {
            return null;
        }
        return (SQLName)this.getTableSource().getExpr();
    }

    public long nameHashCode64() {
        if (this.getTableSource() == null) {
            return 0L;
        }
        return ((SQLName)this.getTableSource().getExpr()).nameHashCode64();
    }

    public void setName(SQLName name) {
        this.setTableSource(new SQLExprTableSource(name));
    }

    public List<SQLAssignItem> getTableOptions() {
        return this.tableOptions;
    }

    public SQLPartitionBy getPartition() {
        return this.partition;
    }

    public void setPartition(SQLPartitionBy partition) {
        this.partition = partition;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.getTableSource());
            this.acceptChild(visitor, this.getItems());
        }
        visitor.endVisit(this);
    }

    @Override
    public List<SQLObject> getChildren() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        if (this.tableSource != null) {
            children.add(this.tableSource);
        }
        children.addAll(this.items);
        return children;
    }

    public String getTableName() {
        if (this.tableSource == null) {
            return null;
        }
        SQLExpr expr = this.tableSource.getExpr();
        if (expr instanceof SQLIdentifierExpr) {
            return ((SQLIdentifierExpr)expr).getName();
        }
        if (expr instanceof SQLPropertyExpr) {
            return ((SQLPropertyExpr)expr).getName();
        }
        return null;
    }

    public String getSchema() {
        SQLName name = this.getName();
        if (name == null) {
            return null;
        }
        if (name instanceof SQLPropertyExpr) {
            return ((SQLPropertyExpr)name).getOwnernName();
        }
        return null;
    }

    public void setItems(List<SQLAlterTableItem> items) {
        this.items = items;
    }

    public boolean isRange() {
        return this.range;
    }

    public void setRange(boolean range) {
        this.range = range;
    }

    public List<SQLSelectOrderByItem> getClusteredBy() {
        return this.clusteredBy;
    }

    public void addClusteredByItem(SQLSelectOrderByItem item) {
        item.setParent(this);
        this.clusteredBy.add(item);
    }

    public List<SQLSelectOrderByItem> getSortedBy() {
        return this.sortedBy;
    }

    public void addSortedByItem(SQLSelectOrderByItem item) {
        item.setParent(this);
        this.sortedBy.add(item);
    }

    public int getBuckets() {
        return this.buckets;
    }

    public void setBuckets(int buckets) {
        this.buckets = buckets;
    }

    public int getShards() {
        return this.shards;
    }

    public void setShards(int shards) {
        this.shards = shards;
    }

    public boolean isNotClustered() {
        return this.notClustered;
    }

    public void setNotClustered(boolean notClustered) {
        this.notClustered = notClustered;
    }

    @Override
    public SQLDDLStatement.DDLObjectType getDDLObjectType() {
        return SQLDDLStatement.DDLObjectType.TABLE;
    }

    public SQLName getOn() {
        return this.on;
    }

    public void setOn(SQLName x) {
        if (x != null) {
            x.setParent(this);
        }
        this.on = x;
    }
}

