/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement;

import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLCommentHint;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLReplaceable;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLSelectGroupByClause
extends SQLObjectImpl
implements SQLReplaceable {
    private final List<SQLExpr> items = new ArrayList<SQLExpr>();
    private SQLExpr having;
    private boolean withRollUp;
    private boolean withCube;
    private boolean distinct;
    private boolean paren;

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            for (int i = 0; i < this.items.size(); ++i) {
                SQLExpr item = this.items.get(i);
                if (item == null) continue;
                item.accept(visitor);
            }
            if (this.having != null) {
                this.having.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isWithRollUp() {
        return this.withRollUp;
    }

    public void setWithRollUp(boolean withRollUp) {
        this.withRollUp = withRollUp;
    }

    public boolean isWithCube() {
        return this.withCube;
    }

    public void setWithCube(boolean withCube) {
        this.withCube = withCube;
    }

    public SQLExpr getHaving() {
        return this.having;
    }

    public void setHaving(SQLExpr having) {
        if (having != null) {
            having.setParent(this);
        }
        this.having = having;
    }

    public void addHaving(SQLExpr condition) {
        if (condition == null) {
            return;
        }
        this.having = this.having == null ? condition : SQLBinaryOpExpr.and(this.having, condition);
    }

    public List<SQLExpr> getItems() {
        return this.items;
    }

    public boolean containsItem(SQLExpr item) {
        return this.items.contains(item);
    }

    public void addItem(SQLExpr sqlExpr) {
        if (sqlExpr != null) {
            sqlExpr.setParent(this);
            this.items.add(sqlExpr);
        }
    }

    public void addItem(int index, SQLExpr sqlExpr) {
        if (sqlExpr != null) {
            sqlExpr.setParent(this);
            this.items.add(index, sqlExpr);
        }
    }

    @Override
    public SQLSelectGroupByClause clone() {
        SQLSelectGroupByClause x = new SQLSelectGroupByClause();
        for (SQLExpr item : this.items) {
            SQLExpr item2 = item.clone();
            item2.setParent(x);
            x.items.add(item2);
        }
        if (this.having != null) {
            x.setHaving(this.having.clone());
        }
        x.withRollUp = this.withRollUp;
        x.withCube = this.withCube;
        x.distinct = this.distinct;
        x.paren = this.paren;
        if (this.hint != null) {
            x.setHint(this.hint.clone());
        }
        return x;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (expr == this.having) {
            this.setHaving(target);
            return true;
        }
        for (int i = this.items.size() - 1; i >= 0; --i) {
            if (this.items.get(i) != expr) continue;
            if (target instanceof SQLIntegerExpr) {
                this.items.remove(i);
            } else {
                this.items.set(i, target);
            }
            return true;
        }
        return false;
    }

    @Override
    public SQLCommentHint getHint() {
        return this.hint;
    }

    @Override
    public void setHint(SQLCommentHint hint) {
        this.hint = hint;
    }

    public boolean isParen() {
        return this.paren;
    }

    public void setParen(boolean paren) {
        this.paren = paren;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLSelectGroupByClause that = (SQLSelectGroupByClause)o;
        if (this.withRollUp != that.withRollUp) {
            return false;
        }
        if (this.withCube != that.withCube) {
            return false;
        }
        if (this.distinct != that.distinct) {
            return false;
        }
        if (this.paren != that.paren) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.having != null ? !this.having.equals(that.having) : that.having != null) {
            return false;
        }
        return this.hint != null ? this.hint.equals(that.hint) : that.hint == null;
    }

    public int hashCode() {
        int result = this.items != null ? this.items.hashCode() : 0;
        result = 31 * result + (this.having != null ? this.having.hashCode() : 0);
        result = 31 * result + (this.withRollUp ? 1 : 0);
        result = 31 * result + (this.withCube ? 1 : 0);
        result = 31 * result + (this.distinct ? 1 : 0);
        result = 31 * result + (this.paren ? 1 : 0);
        result = 31 * result + (this.hint != null ? this.hint.hashCode() : 0);
        return result;
    }
}

