/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement;

import com.hundsun.lightdb.shaded.com.alibaba.druid.DbType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLDbTypedObject;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLLimit;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLOrderBy;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectQueryBase;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SQLUnionQuery
extends SQLSelectQueryBase
implements SQLDbTypedObject {
    private List<SQLSelectQuery> relations = new ArrayList<SQLSelectQuery>();
    private SQLUnionOperator operator = SQLUnionOperator.UNION;
    private SQLOrderBy orderBy;
    private SQLLimit limit;
    private DbType dbType;

    public SQLUnionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SQLUnionOperator operator) {
        this.operator = operator;
    }

    public SQLUnionQuery() {
    }

    public SQLUnionQuery(DbType dbType) {
        this.dbType = dbType;
    }

    public SQLUnionQuery(SQLSelectQuery left, SQLUnionOperator operator, SQLSelectQuery right) {
        this.setLeft(left);
        this.operator = operator;
        this.setRight(right);
    }

    public List<SQLSelectQuery> getRelations() {
        return this.relations;
    }

    public boolean isEmpty() {
        return this.relations.isEmpty();
    }

    public void addRelation(SQLSelectQuery relation) {
        if (relation != null) {
            relation.setParent(this);
        }
        this.relations.add(relation);
    }

    public SQLSelectQuery getLeft() {
        if (this.relations.isEmpty()) {
            return null;
        }
        return this.relations.get(0);
    }

    public void setLeft(SQLSelectQuery left) {
        if (left != null) {
            left.setParent(this);
        }
        if (this.relations.isEmpty()) {
            this.relations.add(left);
        } else if (this.relations.size() <= 2) {
            this.relations.set(0, left);
        } else {
            throw new UnsupportedOperationException("multi-union");
        }
    }

    public SQLSelectQuery getRight() {
        if (this.relations.size() < 2) {
            return null;
        }
        if (this.relations.size() == 2) {
            return this.relations.get(1);
        }
        throw new UnsupportedOperationException("multi-union");
    }

    public void setRight(SQLSelectQuery right) {
        if (right != null) {
            right.setParent(this);
        }
        if (this.relations.isEmpty()) {
            this.relations.add(null);
        }
        if (this.relations.size() == 1) {
            this.relations.add(right);
        } else if (this.relations.size() == 2) {
            this.relations.set(1, right);
        } else {
            throw new UnsupportedOperationException("multi-union");
        }
    }

    public SQLOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(SQLOrderBy orderBy) {
        if (orderBy != null) {
            orderBy.setParent(this);
        }
        this.orderBy = orderBy;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            for (SQLSelectQuery relation : this.relations) {
                relation.accept(visitor);
            }
            if (this.orderBy != null) {
                this.orderBy.accept(visitor);
            }
            if (this.limit != null) {
                this.limit.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public SQLLimit getLimit() {
        return this.limit;
    }

    public void setLimit(SQLLimit limit) {
        if (limit != null) {
            limit.setParent(this);
        }
        this.limit = limit;
    }

    @Override
    public SQLUnionQuery clone() {
        SQLUnionQuery x = new SQLUnionQuery();
        x.parenthesized = this.parenthesized;
        for (SQLSelectQuery relation : this.relations) {
            SQLSelectQuery r = relation.clone();
            r.setParent(x);
            x.relations.add(r);
        }
        x.operator = this.operator;
        if (this.orderBy != null) {
            x.setOrderBy(this.orderBy.clone());
        }
        if (this.limit != null) {
            x.setLimit(this.limit.clone());
        }
        x.dbType = this.dbType;
        return x;
    }

    public SQLSelectQueryBlock getFirstQueryBlock() {
        SQLSelectQuery left = this.getLeft();
        if (left instanceof SQLSelectQueryBlock) {
            return (SQLSelectQueryBlock)left;
        }
        if (left instanceof SQLUnionQuery) {
            return ((SQLUnionQuery)left).getFirstQueryBlock();
        }
        return null;
    }

    @Override
    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public boolean replace(SQLSelectQuery cmp, SQLSelectQuery target) {
        for (int i = 0; i < this.relations.size(); ++i) {
            SQLSelectQuery r = this.relations.get(i);
            if (r != cmp) continue;
            if (cmp != null) {
                cmp.setParent(this);
            }
            this.relations.set(i, cmp);
            return true;
        }
        return false;
    }

    public List<SQLSelectQuery> getChildren() {
        boolean bracket;
        boolean bl = bracket = this.parenthesized && !(this.parent instanceof SQLUnionQueryTableSource);
        if (this.relations.size() > 2) {
            return this.relations;
        }
        SQLSelectQuery left = this.getLeft();
        SQLSelectQuery right = this.getRight();
        if (!bracket && left instanceof SQLUnionQuery && ((SQLUnionQuery)left).getOperator() == this.operator && !right.isParenthesized() && this.orderBy == null) {
            SQLSelectQuery leftRight;
            SQLSelectQuery leftLeft;
            SQLUnionQuery leftUnion = (SQLUnionQuery)left;
            ArrayList<SQLSelectQuery> rights = new ArrayList<SQLSelectQuery>();
            rights.add(right);
            while (true) {
                leftLeft = leftUnion.getLeft();
                leftRight = leftUnion.getRight();
                if (leftUnion.isParenthesized() || leftUnion.getOrderBy() != null || leftLeft.isParenthesized() || leftRight.isParenthesized() || !(leftLeft instanceof SQLUnionQuery) || ((SQLUnionQuery)leftLeft).getOperator() != this.operator) break;
                rights.add(leftRight);
                leftUnion = (SQLUnionQuery)leftLeft;
            }
            rights.add(leftRight);
            rights.add(leftLeft);
            Collections.reverse(rights);
            return rights;
        }
        return Arrays.asList(left, right);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLUnionQuery that = (SQLUnionQuery)o;
        if (this.parenthesized != that.parenthesized) {
            return false;
        }
        if (this.relations != null ? !this.relations.equals(that.relations) : that.relations != null) {
            return false;
        }
        if (this.operator != that.operator) {
            return false;
        }
        if (this.orderBy != null ? !this.orderBy.equals(that.orderBy) : that.orderBy != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        return this.dbType == that.dbType;
    }

    public int hashCode() {
        int result = this.parenthesized ? 1 : 0;
        result = 31 * result + (this.relations != null ? this.relations.hashCode() : 0);
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.dbType != null ? this.dbType.hashCode() : 0);
        return result;
    }
}

