/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.builder.impl;

import com.hundsun.lightdb.shaded.com.alibaba.druid.DbType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.SQLUtils;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLOrderBy;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.builder.SQLSelectBuilder;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.SQLParserUtils;
import java.util.List;

public class SQLSelectBuilderImpl
implements SQLSelectBuilder {
    private SQLSelectStatement stmt;
    private DbType dbType;

    public SQLSelectBuilderImpl(DbType dbType) {
        this(new SQLSelectStatement(), dbType);
    }

    public SQLSelectBuilderImpl(String sql, DbType dbType) {
        SQLSelectStatement stmt;
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.isEmpty()) {
            throw new IllegalArgumentException("not support empty-statement :" + sql);
        }
        if (stmtList.size() > 1) {
            throw new IllegalArgumentException("not support multi-statement :" + sql);
        }
        this.stmt = stmt = (SQLSelectStatement)stmtList.get(0);
        this.dbType = dbType;
    }

    public SQLSelectBuilderImpl(SQLSelectStatement stmt, DbType dbType) {
        this.stmt = stmt;
        this.dbType = dbType;
    }

    public SQLSelect getSQLSelect() {
        if (this.stmt.getSelect() == null) {
            this.stmt.setSelect(this.createSelect());
        }
        return this.stmt.getSelect();
    }

    @Override
    public SQLSelectStatement getSQLSelectStatement() {
        return this.stmt;
    }

    @Override
    public SQLSelectBuilderImpl select(String ... columns) {
        SQLSelectQueryBlock queryBlock = this.getQueryBlock();
        for (String column : columns) {
            SQLSelectItem selectItem = SQLUtils.toSelectItem(column, this.dbType);
            queryBlock.addSelectItem(selectItem);
        }
        return this;
    }

    @Override
    public SQLSelectBuilderImpl selectWithAlias(String column, String alias) {
        SQLSelectQueryBlock queryBlock = this.getQueryBlock();
        SQLExpr columnExpr = SQLUtils.toSQLExpr(column, this.dbType);
        SQLSelectItem selectItem = new SQLSelectItem(columnExpr, alias);
        queryBlock.addSelectItem(selectItem);
        return this;
    }

    @Override
    public SQLSelectBuilderImpl from(String table) {
        return this.from(table, null);
    }

    @Override
    public SQLSelectBuilderImpl from(String table, String alias) {
        SQLSelectQueryBlock queryBlock = this.getQueryBlock();
        SQLExprTableSource from = new SQLExprTableSource(new SQLIdentifierExpr(table), alias);
        queryBlock.setFrom(from);
        return this;
    }

    @Override
    public SQLSelectBuilderImpl orderBy(String ... columns) {
        SQLSelect select = this.getSQLSelect();
        SQLOrderBy orderBy = select.getOrderBy();
        if (orderBy == null) {
            orderBy = this.createOrderBy();
            select.setOrderBy(orderBy);
        }
        for (String column : columns) {
            SQLSelectOrderByItem orderByItem = SQLUtils.toOrderByItem(column, this.dbType);
            orderBy.addItem(orderByItem);
        }
        return this;
    }

    @Override
    public SQLSelectBuilderImpl groupBy(String expr) {
        SQLSelectQueryBlock queryBlock = this.getQueryBlock();
        SQLSelectGroupByClause groupBy = queryBlock.getGroupBy();
        if (groupBy == null) {
            groupBy = this.createGroupBy();
            queryBlock.setGroupBy(groupBy);
        }
        SQLExpr exprObj = SQLUtils.toSQLExpr(expr, this.dbType);
        groupBy.addItem(exprObj);
        return this;
    }

    @Override
    public SQLSelectBuilderImpl having(String expr) {
        SQLSelectQueryBlock queryBlock = this.getQueryBlock();
        SQLSelectGroupByClause groupBy = queryBlock.getGroupBy();
        if (groupBy == null) {
            groupBy = this.createGroupBy();
            queryBlock.setGroupBy(groupBy);
        }
        SQLExpr exprObj = SQLUtils.toSQLExpr(expr, this.dbType);
        groupBy.setHaving(exprObj);
        return this;
    }

    @Override
    public SQLSelectBuilderImpl into(String expr) {
        SQLSelectQueryBlock queryBlock = this.getQueryBlock();
        SQLExpr exprObj = SQLUtils.toSQLExpr(expr, this.dbType);
        queryBlock.setInto(exprObj);
        return this;
    }

    @Override
    public SQLSelectBuilderImpl where(String expr) {
        SQLSelectQueryBlock queryBlock = this.getQueryBlock();
        SQLExpr exprObj = SQLUtils.toSQLExpr(expr, this.dbType);
        queryBlock.setWhere(exprObj);
        return this;
    }

    @Override
    public SQLSelectBuilderImpl whereAnd(String expr) {
        SQLSelectQueryBlock queryBlock = this.getQueryBlock();
        queryBlock.addWhere(SQLUtils.toSQLExpr(expr, this.dbType));
        return this;
    }

    @Override
    public SQLSelectBuilderImpl whereOr(String expr) {
        SQLSelectQueryBlock queryBlock = this.getQueryBlock();
        SQLExpr exprObj = SQLUtils.toSQLExpr(expr, this.dbType);
        SQLExpr newCondition = SQLUtils.buildCondition(SQLBinaryOperator.BooleanOr, exprObj, false, queryBlock.getWhere());
        queryBlock.setWhere(newCondition);
        return this;
    }

    @Override
    public SQLSelectBuilderImpl limit(int rowCount) {
        return this.limit(rowCount, 0);
    }

    @Override
    public SQLSelectBuilderImpl limit(int rowCount, int offset) {
        this.getQueryBlock().limit(rowCount, offset);
        return this;
    }

    protected SQLSelectQueryBlock getQueryBlock() {
        SQLSelect select = this.getSQLSelect();
        SQLSelectQuery query = select.getQuery();
        if (query == null) {
            query = SQLParserUtils.createSelectQueryBlock(this.dbType);
            select.setQuery(query);
        }
        if (!(query instanceof SQLSelectQueryBlock)) {
            throw new IllegalStateException("not support from, class : " + query.getClass().getName());
        }
        SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
        return queryBlock;
    }

    protected SQLSelect createSelect() {
        return new SQLSelect();
    }

    protected SQLSelectQuery createSelectQueryBlock() {
        return SQLParserUtils.createSelectQueryBlock(this.dbType);
    }

    protected SQLOrderBy createOrderBy() {
        return new SQLOrderBy();
    }

    protected SQLSelectGroupByClause createGroupBy() {
        return new SQLSelectGroupByClause();
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString((SQLObject)this.stmt, this.dbType);
    }
}

