/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.antspark.parser;

import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLName;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.antspark.ast.AntsparkCreateTableStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.antspark.parser.AntsparkExprParser;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.hive.ast.HiveInputOutputFormat;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.ParserException;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.SQLExprParser;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.Token;
import com.hundsun.lightdb.shaded.com.alibaba.druid.util.FnvHash;

public class AntsparkCreateTableParser
extends SQLCreateTableParser {
    public AntsparkCreateTableParser(String sql) {
        super(new AntsparkExprParser(sql));
    }

    public AntsparkCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLCreateTableStatement parseCreateTable(boolean acceptCreate) {
        Object name;
        SQLExpr comment;
        SQLExpr expr;
        AntsparkCreateTableStatement stmt = new AntsparkCreateTableStatement();
        if (acceptCreate) {
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                stmt.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.CREATE);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            this.lexer.nextToken();
            stmt.setExternal(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TEMPORARY)) {
            this.lexer.nextToken();
            stmt.setType(SQLCreateTableStatement.Type.TEMPORARY);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF || this.lexer.identifierEquals(FnvHash.Constants.IF)) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExiists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            do {
                SQLColumnDefinition column;
                Token token;
                if ((token = this.lexer.token()) == Token.IDENTIFIER || token == Token.LITERAL_ALIAS) {
                    column = this.exprParser.parseColumn();
                    stmt.getTableElementList().add(column);
                } else if (token == Token.PRIMARY || token == Token.UNIQUE || token == Token.CHECK || token == Token.CONSTRAINT || token == Token.FOREIGN) {
                    SQLConstraint constraint = this.exprParser.parseConstaint();
                    constraint.setParent(stmt);
                    stmt.getTableElementList().add((SQLTableElement)((Object)constraint));
                } else {
                    if (token == Token.TABLESPACE) {
                        throw new ParserException("TODO " + this.lexer.info());
                    }
                    column = this.exprParser.parseColumn();
                    stmt.getTableElementList().add(column);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            } while (this.lexer.token() != Token.RPAREN);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            expr = this.exprParser.name();
            stmt.setDatasource(expr);
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            comment = this.exprParser.expr();
            stmt.setComment(comment);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.MAPPED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            this.exprParser.parseAssignItem(stmt.getMappedBy(), (SQLObject)stmt);
        }
        if (this.lexer.token() == Token.PARTITIONED) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            while (true) {
                if (this.lexer.token() != Token.IDENTIFIER) {
                    throw new ParserException("expect identifier. " + this.lexer.info());
                }
                SQLColumnDefinition column = this.exprParser.parseColumn();
                stmt.addPartitionColumn(column);
                if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                    column.addAfterComment(this.lexer.readAndResetComments());
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
                if (!this.lexer.isKeepComments() || !this.lexer.hasComment()) continue;
                column.addAfterComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTERED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            while (true) {
                SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
                stmt.addClusteredByItem(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SKEWED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            this.exprParser.exprList(stmt.getSkewedBy(), stmt);
            this.accept(Token.RPAREN);
            this.accept(Token.ON);
            this.accept(Token.LPAREN);
            while (true) {
                if (this.lexer.token() == Token.LPAREN) {
                    SQLListExpr list = new SQLListExpr();
                    this.lexer.nextToken();
                    this.exprParser.exprList(list.getItems(), list);
                    this.accept(Token.RPAREN);
                    stmt.addSkewedByOn(list);
                } else {
                    expr = this.exprParser.expr();
                    stmt.addSkewedByOn(expr);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SORTED)) {
            this.parseSortedBy(stmt);
        }
        if (this.lexer.token() == Token.ROW || this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
            this.parseRowFormat(stmt);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SORTED)) {
            this.parseSortedBy(stmt);
        }
        if (stmt.getClusteredBy().size() > 0 || stmt.getSortedBy().size() > 0) {
            this.accept(Token.INTO);
            if (this.lexer.token() != Token.LITERAL_INT) {
                throw new ParserException("into buckets must be integer. " + this.lexer.info());
            }
            stmt.setBuckets(this.lexer.integerValue().intValue());
            this.lexer.nextToken();
            this.acceptIdentifier("BUCKETS");
        }
        if (this.lexer.token() == Token.ROW || this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
            this.parseRowFormat(stmt);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
            this.lexer.nextToken();
            this.accept(Token.AS);
            if (this.lexer.identifierEquals(FnvHash.Constants.INPUTFORMAT)) {
                HiveInputOutputFormat format = new HiveInputOutputFormat();
                this.lexer.nextToken();
                format.setInput(this.exprParser.primary());
                if (this.lexer.identifierEquals(FnvHash.Constants.OUTPUTFORMAT)) {
                    this.lexer.nextToken();
                    format.setOutput(this.exprParser.primary());
                }
                stmt.setStoredAs(format);
            } else {
                name = this.exprParser.name();
                stmt.setStoredAs((SQLExpr)name);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
            this.lexer.nextToken();
            SQLExpr location = this.exprParser.expr();
            stmt.setLocation(location);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            do {
                name = this.lexer.stringVal();
                this.lexer.nextToken();
                this.accept(Token.EQ);
                SQLExpr value = this.exprParser.primary();
                stmt.addOption((String)name, value);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            } while (this.lexer.token() != Token.RPAREN);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.META)) {
            this.lexer.nextToken();
            this.acceptIdentifier("LIFECYCLE");
            stmt.setMetaLifeCycle(this.exprParser.primary());
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            SQLSelect select = this.createSQLSelectParser().select();
            stmt.setSelect(select);
        }
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            name = this.exprParser.name();
            stmt.setLike((SQLName)name);
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            comment = this.exprParser.expr();
            stmt.setComment(comment);
        }
        return stmt;
    }

    private void parseRowFormat(AntsparkCreateTableStatement stmt) {
    }

    private void parseSortedBy(AntsparkCreateTableStatement stmt) {
    }
}

