/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.antspark.visitor;

import com.hundsun.lightdb.shaded.com.alibaba.druid.DbType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.antspark.ast.AntsparkCreateTableStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.antspark.visitor.AntsparkVisitor;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.hive.visitor.HiveOutputVisitor;
import java.util.List;
import java.util.Map;

public class AntsparkOutputVisitor
extends HiveOutputVisitor
implements AntsparkVisitor {
    public AntsparkOutputVisitor(Appendable appender, DbType dbType) {
        super(appender, dbType);
    }

    public AntsparkOutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public boolean visit(AntsparkCreateTableStatement x) {
        SQLExpr location;
        Map<String, SQLObject> serdeProperties;
        SQLSelect select;
        SQLExpr storedAs;
        int buckets;
        List<SQLSelectOrderByItem> sortedBy;
        List<SQLSelectOrderByItem> clusteredBy;
        int partitionSize;
        List<SQLTableElement> tableElementList;
        int size;
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isExternal()) {
            this.print0(this.ucase ? "EXTERNAL " : "external ");
        }
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "TABLE IF NOT EXISTS " : "table if not exists ");
        } else {
            this.print0(this.ucase ? "TABLE " : "table ");
        }
        x.getName().accept(this);
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if ((size = (tableElementList = x.getTableElementList()).size()) > 0) {
            this.print0(" (");
            if (this.isPrettyFormat() && x.hasBodyBeforeComment()) {
                this.print(' ');
                this.printlnComment(x.getBodyBeforeCommentsDirect());
            }
            ++this.indentCount;
            this.println();
            for (int i = 0; i < size; ++i) {
                SQLTableElement element = tableElementList.get(i);
                element.accept(this);
                if (i != size - 1) {
                    this.print(',');
                }
                if (this.isPrettyFormat() && element.hasAfterComment()) {
                    this.print(' ');
                    this.printlnComment(element.getAfterCommentsDirect());
                }
                if (i == size - 1) continue;
                this.println();
            }
            --this.indentCount;
            this.println();
            this.print(')');
        }
        if (x.getDatasource() != null) {
            this.println();
            this.print0(this.ucase ? "USING " : "using ");
            this.print0(x.getDatasource().toString());
        }
        if (x.getComment() != null) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            x.getComment().accept(this);
        }
        if ((partitionSize = x.getPartitionColumns().size()) > 0) {
            this.println();
            this.print0(this.ucase ? "PARTITIONED BY (" : "partitioned by (");
            ++this.indentCount;
            this.println();
            for (int i = 0; i < partitionSize; ++i) {
                SQLColumnDefinition column = x.getPartitionColumns().get(i);
                column.accept(this);
                if (i != partitionSize - 1) {
                    this.print(',');
                }
                if (this.isPrettyFormat() && column.hasAfterComment()) {
                    this.print(' ');
                    this.printlnComment(column.getAfterCommentsDirect());
                }
                if (i == partitionSize - 1) continue;
                this.println();
            }
            --this.indentCount;
            this.println();
            this.print(')');
        }
        if ((clusteredBy = x.getClusteredBy()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "CLUSTERED BY (" : "clustered by (");
            this.printAndAccept(clusteredBy, ",");
            this.print(')');
        }
        if ((sortedBy = x.getSortedBy()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "SORTED BY (" : "sorted by (");
            this.printAndAccept(sortedBy, ", ");
            this.print(')');
        }
        if ((buckets = x.getBuckets()) > 0) {
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            this.print(buckets);
            this.print0(this.ucase ? " BUCKETS" : " buckets");
        }
        if ((storedAs = x.getStoredAs()) != null) {
            this.println();
            this.print0(this.ucase ? "STORED AS " : "stored as ");
            storedAs.accept(this);
        }
        if ((select = x.getSelect()) != null) {
            this.println();
            this.print0(this.ucase ? "AS" : "as");
            this.println();
            select.accept(this);
        }
        if ((serdeProperties = x.getSerdeProperties()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "TBLPROPERTIES (" : "tblproperties (");
            String seperator = "";
            for (Map.Entry<String, SQLObject> entry : serdeProperties.entrySet()) {
                this.print0("'" + entry.getKey() + "'='");
                entry.getValue().accept(this);
                this.print0("'" + seperator);
                seperator = ",";
            }
            this.print(')');
        }
        if ((location = x.getLocation()) != null) {
            this.println();
            this.print0(this.ucase ? "LOCATION " : "location ");
            location.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(AntsparkCreateTableStatement x) {
    }
}

