/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.db2.parser;

import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLName;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateTableStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.db2.parser.DB2ExprParser;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.ParserException;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.SQLExprParser;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.Token;
import com.hundsun.lightdb.shaded.com.alibaba.druid.util.FnvHash;

public class DB2CreateTableParser
extends SQLCreateTableParser {
    public DB2CreateTableParser(String sql) {
        super(new DB2ExprParser(sql));
    }

    public DB2CreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SQLCreateTableStatement parseCreateTable(boolean acceptCreate) {
        DB2CreateTableStatement createTable = this.newCreateStatement();
        if (acceptCreate) {
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                createTable.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.CREATE);
        }
        if (this.lexer.identifierEquals("GLOBAL")) {
            this.lexer.nextToken();
            if (!this.lexer.identifierEquals("TEMPORARY")) throw new ParserException("syntax error " + this.lexer.info());
            this.lexer.nextToken();
            createTable.setType(SQLCreateTableStatement.Type.GLOBAL_TEMPORARY);
        } else if (this.lexer.token() == Token.IDENTIFIER && this.lexer.stringVal().equalsIgnoreCase("LOCAL")) {
            this.lexer.nextToken();
            if (this.lexer.token() != Token.IDENTIFIER || !this.lexer.stringVal().equalsIgnoreCase("TEMPORAY")) throw new ParserException("syntax error. " + this.lexer.info());
            this.lexer.nextToken();
            createTable.setType(SQLCreateTableStatement.Type.LOCAL_TEMPORARY);
        }
        this.accept(Token.TABLE);
        createTable.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            do {
                SQLColumnDefinition column;
                Token token;
                if ((token = this.lexer.token()) == Token.IDENTIFIER || token == Token.LITERAL_ALIAS) {
                    column = this.exprParser.parseColumn();
                    createTable.getTableElementList().add(column);
                } else if (token == Token.PRIMARY || token == Token.UNIQUE || token == Token.CHECK || token == Token.CONSTRAINT || token == Token.FOREIGN) {
                    SQLConstraint constraint = this.exprParser.parseConstaint();
                    constraint.setParent(createTable);
                    createTable.getTableElementList().add((SQLTableElement)((Object)constraint));
                } else {
                    if (token == Token.TABLESPACE) {
                        throw new ParserException("TODO " + this.lexer.info());
                    }
                    column = this.exprParser.parseColumn();
                    createTable.getTableElementList().add(column);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            } while (this.lexer.token() != Token.RPAREN);
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals("INHERITS")) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                SQLName inherits = this.exprParser.name();
                createTable.setInherits(new SQLExprTableSource(inherits));
                this.accept(Token.RPAREN);
            }
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            SQLSelect select = this.createSQLSelectParser().select();
            createTable.setSelect(select);
        }
        while (true) {
            if (this.lexer.identifierEquals(FnvHash.Constants.DATA)) {
                this.lexer.nextToken();
                this.acceptIdentifier("CAPTURE");
                if (!this.lexer.identifierEquals(FnvHash.Constants.NONE)) throw new ParserException("TODO " + this.lexer.info());
                this.lexer.nextToken();
                createTable.setDataCaptureNone(true);
                continue;
            }
            if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.DATABASE) {
                    this.lexer.nextToken();
                    SQLName database = this.exprParser.name();
                    createTable.setDatabase(database);
                    continue;
                }
                if (this.lexer.identifierEquals("tablespace")) {
                    throw new ParserException("TODO " + this.lexer.info());
                }
                SQLName tablespace = this.exprParser.name();
                createTable.setTablespace(tablespace);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONING)) {
                SQLPartitionByHash partitionBy = new SQLPartitionByHash();
                this.lexer.nextToken();
                this.accept(Token.KEY);
                this.accept(Token.LPAREN);
                this.exprParser.exprList(partitionBy.getColumns(), partitionBy);
                this.accept(Token.RPAREN);
                this.accept(Token.USING);
                this.acceptIdentifier("HASHING");
                createTable.setPartitioning(partitionBy);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.VALIDPROC)) {
                this.lexer.nextToken();
                SQLName validproc = this.exprParser.name();
                createTable.setValidproc(validproc);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.COMPRESS)) {
                this.lexer.nextToken();
                createTable.setCompress(true);
                if (!this.lexer.identifierEquals(FnvHash.Constants.YES)) continue;
                this.lexer.nextToken();
                continue;
            }
            if (this.lexer.token() != Token.INDEX) return createTable;
            this.lexer.nextToken();
            this.accept(Token.IN);
            SQLName indexIn = this.exprParser.name();
            createTable.setIndexIn(indexIn);
        }
    }

    @Override
    protected DB2CreateTableStatement newCreateStatement() {
        return new DB2CreateTableStatement();
    }
}

