/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.h2.parser;

import com.hundsun.lightdb.shaded.com.alibaba.druid.DbType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLName;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.h2.parser.H2ExprParser;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.h2.parser.H2SelectParser;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.Lexer;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.SQLParserFeature;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.SQLStatementParser;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.Token;

public class H2StatementParser
extends SQLStatementParser {
    public H2StatementParser(String sql) {
        super(new H2ExprParser(sql));
    }

    public H2StatementParser(String sql, SQLParserFeature ... features) {
        super(new H2ExprParser(sql, features));
    }

    public H2StatementParser(Lexer lexer) {
        super(new H2ExprParser(lexer));
    }

    @Override
    public H2SelectParser createSQLSelectParser() {
        return new H2SelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLStatement parseMerge() {
        this.accept(Token.MERGE);
        this.accept(Token.INTO);
        SQLReplaceStatement stmt = new SQLReplaceStatement();
        stmt.setDbType(DbType.h2);
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.lexer.token() == Token.KEY) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.exprParser.exprList(stmt.getColumns(), stmt);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES || this.lexer.identifierEquals("VALUE")) {
            this.lexer.nextToken();
            this.parseValueClause(stmt.getValuesList(), null, 0, stmt);
        } else if (this.lexer.token() == Token.SELECT) {
            SQLQueryExpr queryExpr = (SQLQueryExpr)this.exprParser.expr();
            stmt.setQuery(queryExpr);
        } else if (this.lexer.token() == Token.LPAREN) {
            SQLSelect select = this.createSQLSelectParser().select();
            SQLQueryExpr queryExpr = new SQLQueryExpr(select);
            stmt.setQuery(queryExpr);
        }
        return stmt;
    }

    @Override
    protected void parseInsert0(SQLInsertInto insertStatement, boolean acceptSubQuery) {
        super.parseInsert0(insertStatement, acceptSubQuery);
        this.parseSetStatement(insertStatement);
    }

    private void parseSetStatement(SQLInsertInto insertStatement) {
        if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
            insertStatement.addValueCause(values);
            while (true) {
                SQLName name = this.exprParser.name();
                insertStatement.addColumn(name);
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                } else {
                    this.accept(Token.COLONEQ);
                }
                values.addValue(this.exprParser.expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
    }
}

