/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.hive.parser;

import com.hundsun.lightdb.shaded.com.alibaba.druid.DbType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLCommentHint;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLName;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLAlterDatabaseStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLExportTableStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLExternalRecordFormat;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLImportTableStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLShowColumnsStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLShowCreateTableStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLShowDatabasesStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLShowIndexesStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLShowPartitionsStmt;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLShowViewsStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.hive.ast.HiveAddJarStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.hive.ast.HiveInsert;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.hive.parser.HiveCreateTableParser;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.hive.parser.HiveExprParser;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.hive.parser.HiveSelectParser;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.hive.stmt.HiveLoadDataStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.Lexer;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.ParserException;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.SQLParserFeature;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.SQLStatementParser;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.parser.Token;
import com.hundsun.lightdb.shaded.com.alibaba.druid.util.FnvHash;
import java.util.List;

public class HiveStatementParser
extends SQLStatementParser {
    public HiveStatementParser(String sql) {
        super(new HiveExprParser(sql));
        this.dbType = DbType.hive;
    }

    public HiveStatementParser(String sql, SQLParserFeature ... features) {
        super(new HiveExprParser(sql, features));
        this.dbType = DbType.hive;
    }

    public HiveStatementParser(Lexer lexer) {
        super(new HiveExprParser(lexer));
        this.dbType = DbType.hive;
    }

    @Override
    public HiveSelectParser createSQLSelectParser() {
        return new HiveSelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new HiveCreateTableParser(this.exprParser);
    }

    @Override
    public SQLStatement parseInsert() {
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            HiveMultiInsertStatement stmt = new HiveMultiInsertStatement();
            if (this.lexer.token() == Token.IDENTIFIER) {
                SQLName tableName = this.exprParser.name();
                SQLExprTableSource from = new SQLExprTableSource(tableName);
                SQLTableSource tableSource = this.createSQLSelectParser().parseTableSourceRest(from);
                stmt.setFrom(tableSource);
                if (this.lexer.token() == Token.IDENTIFIER) {
                    from.setAlias(this.lexer.stringVal());
                    this.lexer.nextToken();
                }
            } else {
                this.accept(Token.LPAREN);
                HiveSelectParser selectParser = this.createSQLSelectParser();
                SQLSelect select = selectParser.select();
                this.accept(Token.RPAREN);
                String alias = this.lexer.stringVal();
                this.accept(Token.IDENTIFIER);
                SQLTableSource from = new SQLSubqueryTableSource(select, alias);
                switch (this.lexer.token()) {
                    case LEFT: 
                    case RIGHT: 
                    case FULL: 
                    case JOIN: {
                        from = selectParser.parseTableSourceRest(from);
                        break;
                    }
                }
                stmt.setFrom(from);
            }
            do {
                HiveInsert insert = this.parseHiveInsert();
                stmt.addItem(insert);
            } while (this.lexer.token() == Token.INSERT);
            return stmt;
        }
        return this.parseHiveInsertStmt();
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        SQLStatement stmt;
        if (this.lexer.token() == Token.HINT) {
            List<SQLCommentHint> hints = this.exprParser.parseHints();
            boolean tddlHints = false;
            boolean accept = false;
            boolean acceptHint = false;
            switch (this.lexer.token()) {
                case SELECT: 
                case WITH: 
                case DELETE: 
                case UPDATE: 
                case INSERT: 
                case SHOW: 
                case REPLACE: 
                case TRUNCATE: 
                case DROP: 
                case ALTER: 
                case CREATE: 
                case CHECK: 
                case SET: 
                case DESC: 
                case OPTIMIZE: 
                case ANALYZE: 
                case KILL: 
                case EXPLAIN: 
                case LPAREN: {
                    acceptHint = true;
                }
            }
            if (this.lexer.identifierEquals("MSCK")) {
                acceptHint = true;
            }
            if (acceptHint) {
                SQLStatementImpl stmt2 = (SQLStatementImpl)this.parseStatement();
                stmt2.setHeadHints(hints);
                statementList.add(stmt2);
                return true;
            }
        }
        if (this.lexer.token() == Token.FROM) {
            stmt = this.parseInsert();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOAD)) {
            stmt = this.parseLoad();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ANALYZE)) {
            stmt = this.parseAnalyze();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXPORT)) {
            stmt = this.parseExport();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.IMPORT)) {
            stmt = this.parseImport();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ADD) && (stmt = this.parseAdd()) != null) {
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("MSCK")) {
            stmt = this.parseMsck();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SHOW)) {
            Lexer.SavePoint savePoint = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.VIEWS)) {
                this.lexer.nextToken();
                SQLShowViewsStatement stmt3 = new SQLShowViewsStatement();
                if (this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    SQLName db = this.exprParser.name();
                    stmt3.setDatabase(db);
                }
                if (this.lexer.token() == Token.LIKE) {
                    this.lexer.nextToken();
                    SQLExpr pattern = this.exprParser.expr();
                    stmt3.setLike(pattern);
                }
                statementList.add(stmt3);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TABLES)) {
                this.lexer.reset(savePoint);
                SQLShowTablesStatement stmt4 = this.parseShowTables();
                statementList.add(stmt4);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.DATABASES)) {
                this.lexer.nextToken();
                SQLShowDatabasesStatement stmt5 = this.parseShowDatabases(false);
                statementList.add(stmt5);
                return true;
            }
            if (this.lexer.token() == Token.INDEX) {
                this.lexer.nextToken();
                SQLShowIndexesStatement stmt6 = new SQLShowIndexesStatement();
                stmt6.setType("INDEX");
                if (this.lexer.token() == Token.ON) {
                    this.lexer.nextToken();
                    SQLName table = this.exprParser.name();
                    stmt6.setTable(table);
                }
                if (this.lexer.token() == Token.HINT) {
                    stmt6.setHints(this.exprParser.parseHints());
                }
                statementList.add(stmt6);
                return true;
            }
            if (this.lexer.token() == Token.CREATE) {
                SQLShowCreateTableStatement stmt7 = this.parseShowCreateTable();
                statementList.add(stmt7);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS)) {
                this.lexer.nextToken();
                SQLShowPartitionsStmt stmt8 = new SQLShowPartitionsStmt();
                if (this.lexer.token() == Token.FROM) {
                    this.lexer.nextToken();
                }
                SQLExpr expr = this.exprParser.expr();
                stmt8.setTableSource(new SQLExprTableSource(expr));
                if (this.lexer.token() == Token.PARTITION) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(stmt8.getPartition(), stmt8, false);
                    this.accept(Token.RPAREN);
                }
                if (this.lexer.token() == Token.WHERE) {
                    this.lexer.nextToken();
                    stmt8.setWhere(this.exprParser.expr());
                }
                statementList.add(stmt8);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.COLUMNS)) {
                this.lexer.nextToken();
                SQLShowColumnsStatement stmt9 = new SQLShowColumnsStatement();
                if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    SQLName table = this.exprParser.name();
                    if (this.lexer.token() == Token.SUB && table instanceof SQLIdentifierExpr) {
                        this.lexer.mark();
                        this.lexer.nextToken();
                        String strVal = this.lexer.stringVal();
                        this.lexer.nextToken();
                        if (table instanceof SQLIdentifierExpr) {
                            SQLIdentifierExpr ident = (SQLIdentifierExpr)table;
                            table = new SQLIdentifierExpr(ident.getName() + "-" + strVal);
                        }
                    }
                    stmt9.setTable(table);
                }
                if (this.lexer.token() == Token.LIKE) {
                    this.lexer.nextToken();
                    SQLExpr like = this.exprParser.expr();
                    stmt9.setLike(like);
                }
                if (this.lexer.token() == Token.WHERE) {
                    this.lexer.nextToken();
                    SQLExpr where = this.exprParser.expr();
                    stmt9.setWhere(where);
                }
                statementList.add(stmt9);
                return true;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        return false;
    }

    protected HiveLoadDataStatement parseLoad() {
        this.acceptIdentifier("LOAD");
        this.acceptIdentifier("DATA");
        HiveLoadDataStatement stmt = new HiveLoadDataStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.LOCAL)) {
            this.lexer.nextToken();
            stmt.setLocal(true);
        }
        this.acceptIdentifier("INPATH");
        SQLExpr inpath = this.exprParser.expr();
        stmt.setInpath(inpath);
        if (this.lexer.token() == Token.OVERWRITE) {
            this.lexer.nextToken();
            stmt.setOverwrite(true);
        }
        this.accept(Token.INTO);
        this.accept(Token.TABLE);
        SQLExpr table = this.exprParser.expr();
        stmt.setInto(table);
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.exprParser.exprList(stmt.getPartition(), stmt);
            this.accept(Token.RPAREN);
        }
        return stmt;
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        HiveCreateTableParser parser = new HiveCreateTableParser(this.exprParser);
        return parser.parseCreateTable();
    }

    @Override
    public SQLCreateFunctionStatement parseCreateFunction() {
        return this.parseHiveCreateFunction();
    }

    @Override
    public SQLCreateIndexStatement parseCreateIndex(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        this.accept(Token.INDEX);
        SQLCreateIndexStatement stmt = new SQLCreateIndexStatement(this.dbType);
        stmt.setName(this.exprParser.name());
        this.accept(Token.ON);
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
        }
        stmt.setTable(this.exprParser.name());
        this.accept(Token.LPAREN);
        while (true) {
            SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
            item.setParent(stmt);
            stmt.addItem(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            String indexType = this.lexer.stringVal();
            this.accept(Token.LITERAL_CHARS);
            stmt.setType(indexType);
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("DEFERRED");
            this.acceptIdentifier("REBUILD");
            stmt.setDeferedRebuild(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.IDXPROPERTIES)) {
            this.lexer.nextToken();
            this.exprParser.parseAssignItem(stmt.getProperties(), (SQLObject)stmt);
        }
        if (this.lexer.token() == Token.IN) {
            this.lexer.nextToken();
            this.accept(Token.TABLE);
            SQLName inTable = this.exprParser.name();
            stmt.setIn(inTable);
        }
        if (this.lexer.token() == Token.ROW || this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
            SQLExternalRecordFormat format = this.getExprParser().parseRowFormat();
            stmt.setRowFormat(format);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
            this.lexer.nextToken();
            this.accept(Token.AS);
            SQLName name = this.exprParser.name();
            stmt.setStoredAs(name);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
            this.lexer.nextToken();
            this.exprParser.parseAssignItem(stmt.getTableProperties(), (SQLObject)stmt);
        }
        return stmt;
    }

    protected SQLStatement parseExport() {
        this.lexer.nextToken();
        this.accept(Token.TABLE);
        SQLExportTableStatement stmt = new SQLExportTableStatement();
        stmt.setTable(new SQLExprTableSource(this.exprParser.name()));
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(stmt.getPartition(), stmt, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            SQLExpr to = this.exprParser.primary();
            stmt.setTo(to);
        }
        return stmt;
    }

    protected SQLStatement parseAdd() {
        Lexer.SavePoint mark = this.lexer.mark();
        this.lexer.nextToken();
        if (this.lexer.identifierEquals("JAR")) {
            this.lexer.nextPath();
            String path = this.lexer.stringVal();
            HiveAddJarStatement stmt = new HiveAddJarStatement();
            stmt.setPath(path);
            this.lexer.nextToken();
            return stmt;
        }
        this.lexer.reset(mark);
        return null;
    }

    protected SQLStatement parseImport() {
        this.lexer.nextToken();
        SQLImportTableStatement stmt = new SQLImportTableStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            this.lexer.nextToken();
            stmt.setExtenal(true);
        }
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            stmt.setTable(new SQLExprTableSource(this.exprParser.name()));
        }
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(stmt.getPartition(), stmt, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLExpr to = this.exprParser.primary();
            stmt.setFrom(to);
        }
        return stmt;
    }

    @Override
    protected SQLStatement parseAlterDatabase() {
        this.accept(Token.ALTER);
        if (this.lexer.token() == Token.SCHEMA) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.DATABASE);
        }
        SQLAlterDatabaseStatement stmt = new SQLAlterDatabaseStatement();
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.DBPROPERTIES)) {
                this.lexer.nextToken();
                this.exprParser.parseAssignItem(stmt.getProperties(), (SQLObject)stmt);
            } else {
                throw new ParserException("TODO " + this.lexer.info());
            }
        }
        return stmt;
    }

    @Override
    protected SQLStatement parseAlterSchema() {
        return this.parseAlterDatabase();
    }

    @Override
    public SQLStatement parseCreateSchema() {
        return this.parseCreateDatabase();
    }

    @Override
    public HiveExprParser getExprParser() {
        return (HiveExprParser)this.exprParser;
    }
}

