/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.mysql.ast.statement;

import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.SQLUtils;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLCommentHint;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.h2.visitor.H2ASTVisitor;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlStatementImpl;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public class MySqlHintStatement
extends MySqlStatementImpl {
    private List<SQLCommentHint> hints;
    private List<SQLStatement> hintStatements;

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof H2ASTVisitor) {
            return;
        }
        super.accept0(visitor);
    }

    @Override
    public void accept0(MySqlASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.hints);
        }
        visitor.endVisit(this);
    }

    public List<SQLCommentHint> getHints() {
        return this.hints;
    }

    public void setHints(List<SQLCommentHint> hints) {
        this.hints = hints;
    }

    public int getHintVersion() {
        if (this.hints.size() != 1) {
            return -1;
        }
        SQLCommentHint hint = this.hints.get(0);
        String text = hint.getText();
        if (text.length() < 7) {
            return -1;
        }
        char c0 = text.charAt(0);
        char c1 = text.charAt(1);
        char c2 = text.charAt(2);
        char c3 = text.charAt(3);
        char c4 = text.charAt(4);
        char c5 = text.charAt(5);
        char c6 = text.charAt(6);
        if (c0 != '!') {
            return -1;
        }
        if (c1 >= '0' && c1 <= '9' && c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9' && c4 >= '0' && c4 <= '9' && c5 >= '0' && c5 <= '9' && c6 == ' ') {
            return (c1 - 48) * 10000 + (c2 - 48) * 1000 + (c3 - 48) * 100 + (c4 - 48) * 10 + (c5 - 48);
        }
        return -1;
    }

    public List<SQLStatement> getHintStatements() {
        int start;
        if (this.hintStatements != null) {
            return this.hintStatements;
        }
        if (this.hints.size() != 1) {
            return null;
        }
        SQLCommentHint hint = this.hints.get(0);
        String text = hint.getText();
        if (text.length() < 7) {
            return null;
        }
        char c0 = text.charAt(0);
        char c1 = text.charAt(1);
        char c2 = text.charAt(2);
        char c3 = text.charAt(3);
        char c4 = text.charAt(4);
        char c5 = text.charAt(5);
        char c6 = text.charAt(6);
        if (c0 != '!') {
            return null;
        }
        if (c1 == ' ') {
            start = 2;
        } else if (c1 >= '0' && c1 <= '9' && c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9' && c4 >= '0' && c4 <= '9' && c5 >= '0' && c5 <= '9' && c6 == ' ') {
            start = 7;
        } else {
            return null;
        }
        String hintSql = text.substring(start);
        this.hintStatements = SQLUtils.parseStatements(hintSql, this.dbType);
        return this.hintStatements;
    }
}

