/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.oracle.visitor;

import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.SQLUtils;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLLimit;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitorAdapter;
import com.hundsun.lightdb.shaded.com.alibaba.druid.util.FnvHash;
import java.util.List;

public class OracleRowNumToLimit
extends OracleASTVisitorAdapter {
    private Context context;
    private boolean removeSelectListRownum = true;

    @Override
    public boolean visit(SQLSelect x) {
        SQLExpr rowCount;
        SQLSelectQueryBlock queryBlock;
        if (x.getWithSubQuery() != null) {
            x.getWithSubQuery().accept(this);
        }
        if (x.getQuery() != null) {
            x.getQuery().accept(this);
        }
        if ((queryBlock = x.getQueryBlock()) != null && queryBlock.getLimit() != null && (rowCount = queryBlock.getLimit().getRowCount()) instanceof SQLIntegerExpr && SQLIntegerExpr.isZero((SQLIntegerExpr)rowCount)) {
            x.setOrderBy(null);
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectQueryBlock x) {
        SQLSelectQueryBlock subQuery;
        SQLSelectQueryBlock subQuery2;
        List<SQLSelectItem> subSelectList;
        SQLTableSource from;
        this.context = new Context(this.context);
        this.context.queryBlock = x;
        SQLExpr where = x.getWhere();
        if (where != null) {
            where.accept(this);
        }
        if ((from = x.getFrom()) != null) {
            from.accept(this);
        }
        this.removeSelectListRowNum(x);
        List<SQLSelectItem> selectList = x.getSelectList();
        for (SQLSelectItem selectItem : selectList) {
            selectItem.accept(this);
        }
        SQLExpr startWith = x.getStartWith();
        if (startWith != null) {
            startWith.accept(this);
        }
        boolean allColumn = false;
        if (selectList.size() == 1) {
            SQLExpr expr = selectList.get(0).getExpr();
            if (expr instanceof SQLAllColumnExpr) {
                allColumn = true;
            } else if (expr instanceof SQLPropertyExpr && ((SQLPropertyExpr)expr).getName().equals("*")) {
                allColumn = true;
            }
        }
        if (!allColumn && x.getFrom() instanceof SQLSubqueryTableSource && ((SQLSubqueryTableSource)x.getFrom()).getSelect().getQuery() instanceof SQLSelectQueryBlock && (subSelectList = (subQuery2 = ((SQLSubqueryTableSource)x.getFrom()).getSelect().getQueryBlock()).getSelectList()).size() >= selectList.size()) {
            boolean match = true;
            for (int i = 0; i < selectList.size(); ++i) {
                if (selectList.get(i).equals(subSelectList.get(i))) continue;
                match = false;
                break;
            }
            if (match) {
                allColumn = true;
            }
        }
        if (x.getParent() instanceof SQLSelect && x.getWhere() == null && x.getOrderBy() == null && allColumn && x.getLimit() != null && x.getFrom() instanceof SQLSubqueryTableSource && ((SQLSubqueryTableSource)x.getFrom()).getSelect().getQuery() instanceof SQLSelectQueryBlock) {
            SQLSelect select = (SQLSelect)x.getParent();
            subQuery = ((SQLSubqueryTableSource)x.getFrom()).getSelect().getQueryBlock();
            subQuery.mergeLimit(x.getLimit());
            x.setLimit(null);
            select.setQuery(subQuery);
            this.context.queryBlock = subQuery;
            this.context.fixLimit();
            subQuery.accept(this);
        }
        if (x.getParent() instanceof SQLUnionQuery && x.getWhere() == null && x.getOrderBy() == null && allColumn && x.getLimit() != null && x.getFrom() instanceof SQLSubqueryTableSource && ((SQLSubqueryTableSource)x.getFrom()).getSelect().getQuery() instanceof SQLSelectQueryBlock) {
            SQLUnionQuery union = (SQLUnionQuery)x.getParent();
            subQuery = ((SQLSubqueryTableSource)x.getFrom()).getSelect().getQueryBlock();
            subQuery.mergeLimit(x.getLimit());
            x.setLimit(null);
            if (union.getLeft() == x) {
                union.setLeft(subQuery);
            } else {
                union.setRight(subQuery);
            }
            this.context.queryBlock = subQuery;
            this.context.fixLimit();
            subQuery.accept(this);
        }
        this.context = this.context.parent;
        return false;
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        if (x.getLeft() != null) {
            x.getLeft().accept(this);
        }
        if (x.getRight() != null) {
            x.getRight().accept(this);
        }
        if (x.getLeft() instanceof SQLSelectQueryBlock && x.getRight() instanceof SQLSelectQueryBlock) {
            if (x.getOperator() == SQLUnionOperator.MINUS) {
                SQLSelectQueryBlock left = (SQLSelectQueryBlock)x.getLeft().clone();
                SQLSelectQueryBlock right = (SQLSelectQueryBlock)x.getRight().clone();
                left.setLimit(null);
                right.setLimit(null);
                boolean eqNonLimit = left.toString().equals(right.toString());
                if (eqNonLimit) {
                    SQLExpr rightOffset;
                    SQLSelectQueryBlock merged = (SQLSelectQueryBlock)x.getLeft().clone();
                    right = (SQLSelectQueryBlock)x.getRight();
                    SQLLimit leftLimit = merged.getLimit();
                    SQLLimit rightLimit = right.getLimit();
                    if (leftLimit == null && rightLimit == null || leftLimit != null && leftLimit.equals(rightLimit)) {
                        merged.setLimit(new SQLLimit(0));
                    } else if (leftLimit == null) {
                        rightOffset = rightLimit.getOffset();
                        if (rightOffset != null && !SQLIntegerExpr.isZero(rightOffset)) {
                            return false;
                        }
                        SQLLimit limit = new SQLLimit();
                        limit.setOffset(rightLimit.getRowCount());
                        merged.setLimit(limit);
                    } else {
                        rightOffset = rightLimit.getOffset();
                        if (rightOffset != null && !SQLIntegerExpr.isZero(rightOffset)) {
                            return false;
                        }
                        SQLExpr leftOffset = leftLimit.getOffset();
                        if (leftOffset != null && !SQLIntegerExpr.isZero(leftOffset)) {
                            return false;
                        }
                        SQLExpr rightRowCount = rightLimit.getRowCount();
                        SQLExpr leftRowCount = leftLimit.getRowCount();
                        SQLLimit limit = new SQLLimit();
                        limit.setOffset(rightRowCount);
                        limit.setRowCount(OracleRowNumToLimit.substract(leftRowCount, rightRowCount));
                        if (SQLIntegerExpr.isZero(limit.getRowCount())) {
                            limit.setRowCount(0);
                            limit.setOffset(null);
                            if (merged.getOrderBy() != null) {
                                merged.setOrderBy(null);
                            }
                        }
                        merged.setLimit(limit);
                    }
                    SQLObject parent = x.getParent();
                    if (parent instanceof SQLSelect) {
                        SQLSelect select = (SQLSelect)parent;
                        select.setQuery(merged);
                    } else if (parent instanceof SQLUnionQuery) {
                        SQLUnionQuery union = (SQLUnionQuery)parent;
                        if (union.getLeft() == x) {
                            union.setLeft(merged);
                        } else {
                            union.setRight(merged);
                        }
                    }
                }
            } else if (x.getOperator() == SQLUnionOperator.INTERSECT) {
                SQLSelectQueryBlock left = (SQLSelectQueryBlock)x.getLeft().clone();
                SQLSelectQueryBlock right = (SQLSelectQueryBlock)x.getRight().clone();
                left.setLimit(null);
                right.setLimit(null);
                boolean eqNonLimit = left.toString().equals(right.toString());
                if (eqNonLimit) {
                    SQLObject parent;
                    SQLSelectQueryBlock merged = (SQLSelectQueryBlock)x.getLeft().clone();
                    right = (SQLSelectQueryBlock)x.getRight();
                    SQLLimit leftLimit = merged.getLimit();
                    SQLLimit rightLimit = right.getLimit();
                    if (rightLimit != null && !rightLimit.equals(leftLimit)) {
                        if (leftLimit == null) {
                            merged.setLimit(rightLimit.clone());
                        } else {
                            SQLExpr rightEnd;
                            SQLLimit limit = new SQLLimit();
                            SQLExpr rightOffset = rightLimit.getOffset();
                            SQLExpr leftOffset = leftLimit.getOffset();
                            if (leftOffset == null) {
                                limit.setOffset(rightOffset);
                            } else if (rightOffset == null) {
                                limit.setOffset(leftOffset);
                            } else if (rightOffset.equals(leftOffset)) {
                                limit.setOffset(leftOffset);
                            } else {
                                if (!(leftOffset instanceof SQLIntegerExpr) || !(rightOffset instanceof SQLIntegerExpr)) {
                                    return false;
                                }
                                limit.setOffset(SQLIntegerExpr.greatst((SQLIntegerExpr)leftOffset, (SQLIntegerExpr)rightOffset));
                            }
                            SQLExpr rightRowCount = rightLimit.getRowCount();
                            SQLExpr leftRowCount = leftLimit.getRowCount();
                            SQLExpr leftEnd = leftOffset == null ? leftRowCount : OracleRowNumToLimit.substract(leftRowCount, leftOffset);
                            SQLExpr sQLExpr = rightEnd = rightOffset == null ? rightRowCount : OracleRowNumToLimit.substract(rightRowCount, rightOffset);
                            if (leftEnd != null && !(leftEnd instanceof SQLIntegerExpr) || rightEnd != null && !(rightEnd instanceof SQLIntegerExpr)) {
                                return false;
                            }
                            SQLIntegerExpr end = SQLIntegerExpr.least((SQLIntegerExpr)leftEnd, (SQLIntegerExpr)rightEnd);
                            if (limit.getOffset() == null) {
                                limit.setRowCount(end);
                            } else {
                                limit.setRowCount(OracleRowNumToLimit.substract(end, limit.getOffset()));
                            }
                            merged.setLimit(limit);
                        }
                    }
                    if ((parent = x.getParent()) instanceof SQLSelect) {
                        SQLSelect select = (SQLSelect)parent;
                        select.setQuery(merged);
                    } else if (parent instanceof SQLUnionQuery) {
                        SQLUnionQuery union = (SQLUnionQuery)parent;
                        if (union.getLeft() == x) {
                            union.setLeft(merged);
                        } else {
                            union.setRight(merged);
                        }
                    }
                }
            }
        }
        return false;
    }

    private void removeSelectListRowNum(SQLSelectQueryBlock x) {
        SQLTableSource from = x.getFrom();
        SQLLimit limit = x.getLimit();
        if (limit == null && from instanceof SQLSubqueryTableSource && ((SQLSubqueryTableSource)from).getSelect().getQuery() instanceof SQLSelectQueryBlock) {
            limit = ((SQLSubqueryTableSource)from).getSelect().getQueryBlock().getLimit();
        }
        if (!this.removeSelectListRownum) {
            return;
        }
        List<SQLSelectItem> selectList = x.getSelectList();
        for (int i = selectList.size() - 1; i >= 0; --i) {
            SQLSelectItem selectItem = selectList.get(i);
            SQLExpr expr = selectItem.getExpr();
            if (!this.isRowNum(expr) || limit == null) continue;
            selectList.remove(i);
        }
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        SQLExpr left = x.getLeft();
        SQLExpr right = x.getRight();
        SQLBinaryOperator op = x.getOperator();
        if (this.context == null || this.context.queryBlock == null) {
            return false;
        }
        boolean isRowNum = this.isRowNum(left);
        if (isRowNum) {
            if (op == SQLBinaryOperator.LessThan) {
                if (SQLUtils.replaceInParent(x, null)) {
                    this.context.setLimit(OracleRowNumToLimit.decrement(right));
                    this.context.fixLimit();
                }
                return false;
            }
            if (op == SQLBinaryOperator.LessThanOrEqual) {
                if (SQLUtils.replaceInParent(x, null)) {
                    this.context.setLimit(right);
                    this.context.fixLimit();
                }
                return false;
            }
            if (op == SQLBinaryOperator.Equality) {
                if (SQLUtils.replaceInParent(x, null)) {
                    this.context.setLimit(right);
                    this.context.fixLimit();
                }
                return false;
            }
            if (op == SQLBinaryOperator.GreaterThanOrEqual) {
                if (SQLUtils.replaceInParent(x, null)) {
                    this.context.setOffset(OracleRowNumToLimit.decrement(right));
                    this.context.fixLimit();
                }
                return false;
            }
            if (op == SQLBinaryOperator.GreaterThan) {
                if (SQLUtils.replaceInParent(x, null)) {
                    this.context.setOffset(right);
                    this.context.fixLimit();
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        if (!this.isRowNum(x.getTestExpr())) {
            return true;
        }
        if (SQLUtils.replaceInParent(x, null)) {
            int val;
            SQLExpr offset = OracleRowNumToLimit.decrement(x.getBeginExpr());
            this.context.setOffset(offset);
            if (offset instanceof SQLIntegerExpr && (val = ((SQLIntegerExpr)offset).getNumber().intValue()) < 0) {
                offset = new SQLIntegerExpr(0);
            }
            this.context.setLimit(OracleRowNumToLimit.substract(x.getEndExpr(), offset));
            SQLLimit limit = this.context.queryBlock.getLimit();
            if (limit != null) {
                limit.putAttribute("oracle.isFixLimit", Boolean.TRUE);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRowNum(SQLExpr x) {
        if (x instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)x;
            long nameHashCode64 = identifierExpr.nameHashCode64();
            if (nameHashCode64 == FnvHash.Constants.ROWNUM) {
                return true;
            }
            if (this.context != null && this.context.queryBlock != null && this.context.queryBlock.getFrom() instanceof SQLSubqueryTableSource && ((SQLSubqueryTableSource)this.context.queryBlock.getFrom()).getSelect().getQuery() instanceof SQLSelectQueryBlock) {
                SQLSelectQueryBlock subQueryBlock = ((SQLSubqueryTableSource)this.context.queryBlock.getFrom()).getSelect().getQueryBlock();
                SQLSelectItem selectItem = subQueryBlock.findSelectItem(nameHashCode64);
                this.context = new Context(this.context);
                this.context.queryBlock = subQueryBlock;
                try {
                    if (selectItem != null && this.isRowNum(selectItem.getExpr())) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    this.context = this.context.parent;
                }
            }
        }
        return false;
    }

    public static SQLExpr decrement(SQLExpr x) {
        if (x instanceof SQLIntegerExpr) {
            int val = ((SQLIntegerExpr)x).getNumber().intValue() - 1;
            return new SQLIntegerExpr(val);
        }
        return new SQLBinaryOpExpr(x.clone(), SQLBinaryOperator.Subtract, new SQLIntegerExpr(1));
    }

    public static SQLExpr substract(SQLExpr left, SQLExpr right) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return null;
        }
        if (left instanceof SQLIntegerExpr && right instanceof SQLIntegerExpr) {
            int rightVal = Math.max(0, ((SQLIntegerExpr)right).getNumber().intValue());
            int leftVal = ((SQLIntegerExpr)left).getNumber().intValue();
            int val = leftVal - rightVal;
            if (val < 0) {
                val = 0;
            }
            return new SQLIntegerExpr(val);
        }
        return new SQLBinaryOpExpr(left, SQLBinaryOperator.Subtract, right);
    }

    public static SQLExpr increment(SQLExpr x) {
        if (x instanceof SQLIntegerExpr) {
            int val = ((SQLIntegerExpr)x).getNumber().intValue() + 1;
            return new SQLIntegerExpr(val);
        }
        return new SQLBinaryOpExpr(x.clone(), SQLBinaryOperator.Add, new SQLIntegerExpr(1));
    }

    public static class Context {
        public final Context parent;
        public SQLSelectQueryBlock queryBlock;

        public Context(Context parent) {
            this.parent = parent;
        }

        void setLimit(SQLExpr x) {
            SQLLimit limit;
            int val;
            if (x instanceof SQLIntegerExpr && (val = ((SQLIntegerExpr)x).getNumber().intValue()) < 0) {
                x = new SQLIntegerExpr(0);
            }
            if ((limit = this.queryBlock.getLimit()) == null) {
                limit = new SQLLimit();
                this.queryBlock.setLimit(limit);
            }
            limit.setRowCount(x);
        }

        void fixLimit() {
            SQLLimit limit = this.queryBlock.getLimit();
            if (limit == null) {
                return;
            }
            if (limit.getAttribute("oracle.isFixLimit") == Boolean.TRUE) {
                return;
            }
            if (limit.getRowCount() != null && limit.getOffset() != null) {
                if (limit.getRowCount() instanceof SQLIntegerExpr && limit.getOffset() instanceof SQLIntegerExpr) {
                    SQLIntegerExpr rowCountExpr = SQLIntegerExpr.substract((SQLIntegerExpr)limit.getRowCount(), (SQLIntegerExpr)limit.getOffset());
                    limit.setRowCount(rowCountExpr);
                } else {
                    limit.setRowCount(OracleRowNumToLimit.substract(limit.getRowCount(), limit.getOffset()));
                }
                limit.putAttribute("oracle.isFixLimit", Boolean.TRUE);
            }
        }

        void setOffset(SQLExpr x) {
            SQLLimit limit;
            int val;
            if (x instanceof SQLIntegerExpr && (val = ((SQLIntegerExpr)x).getNumber().intValue()) < 0) {
                x = new SQLIntegerExpr(0);
            }
            if ((limit = this.queryBlock.getLimit()) == null) {
                limit = new SQLLimit();
                this.queryBlock.setLimit(limit);
            }
            limit.setOffset(x);
        }
    }
}

