/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.oracle.visitor;

import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.hundsun.lightdb.shaded.com.alibaba.druid.util.FnvHash;

public class OracleToMySqlOutputVisitor
extends OracleOutputVisitor {
    public OracleToMySqlOutputVisitor(Appendable appender, boolean printPostSemi) {
        super(appender, printPostSemi);
    }

    public OracleToMySqlOutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public boolean visit(OracleSelectQueryBlock x) {
        SQLSelect select;
        boolean parentIsSelectStatment = false;
        if (x.getParent() instanceof SQLSelect && ((select = (SQLSelect)x.getParent()).getParent() instanceof SQLSelectStatement || select.getParent() instanceof SQLSubqueryTableSource)) {
            parentIsSelectStatment = true;
        }
        if (!parentIsSelectStatment) {
            return super.visit(x);
        }
        if (x.getWhere() instanceof SQLBinaryOpExpr && x.getFrom() instanceof SQLSubqueryTableSource) {
            SQLBinaryOperator op;
            SQLBinaryOpExpr where = (SQLBinaryOpExpr)x.getWhere();
            if (!(where.getRight() instanceof SQLIntegerExpr) || !(where.getLeft() instanceof SQLIdentifierExpr)) {
                return super.visit(x);
            }
            int rownum = ((SQLIntegerExpr)where.getRight()).getNumber().intValue();
            String ident = ((SQLIdentifierExpr)where.getLeft()).getName();
            SQLSelect select2 = ((SQLSubqueryTableSource)x.getFrom()).getSelect();
            SQLSelectQueryBlock queryBlock = null;
            SQLSelect subSelect = null;
            SQLBinaryOpExpr subWhere = null;
            boolean isSubQueryRowNumMapping = false;
            if (select2.getQuery() instanceof SQLSelectQueryBlock) {
                queryBlock = (SQLSelectQueryBlock)select2.getQuery();
                if (queryBlock.getWhere() instanceof SQLBinaryOpExpr) {
                    subWhere = (SQLBinaryOpExpr)queryBlock.getWhere();
                }
                for (SQLSelectItem selectItem : queryBlock.getSelectList()) {
                    if (!OracleToMySqlOutputVisitor.isRowNumber(selectItem.getExpr()) || !(where.getLeft() instanceof SQLIdentifierExpr) || !((SQLIdentifierExpr)where.getLeft()).getName().equals(selectItem.getAlias())) continue;
                    isSubQueryRowNumMapping = true;
                }
                SQLTableSource subTableSource = queryBlock.getFrom();
                if (subTableSource instanceof SQLSubqueryTableSource) {
                    subSelect = ((SQLSubqueryTableSource)subTableSource).getSelect();
                }
            }
            if ("ROWNUM".equalsIgnoreCase(ident)) {
                op = where.getOperator();
                Integer limit = null;
                if (op == SQLBinaryOperator.LessThanOrEqual) {
                    limit = rownum;
                } else if (op == SQLBinaryOperator.LessThan) {
                    limit = rownum - 1;
                }
                if (limit != null) {
                    select2.accept(this);
                    this.println();
                    this.print0(this.ucase ? "LIMIT " : "limit ");
                    this.print(limit);
                    return false;
                }
            } else if (isSubQueryRowNumMapping) {
                op = where.getOperator();
                SQLBinaryOperator subOp = subWhere.getOperator();
                if (OracleToMySqlOutputVisitor.isRowNumber(subWhere.getLeft()) && subWhere.getRight() instanceof SQLIntegerExpr) {
                    int subRownum = ((SQLIntegerExpr)subWhere.getRight()).getNumber().intValue();
                    Integer offset = null;
                    if (op == SQLBinaryOperator.GreaterThanOrEqual) {
                        offset = rownum + 1;
                    } else if (op == SQLBinaryOperator.GreaterThan) {
                        offset = rownum;
                    }
                    if (offset != null) {
                        Integer limit = null;
                        if (subOp == SQLBinaryOperator.LessThanOrEqual) {
                            limit = subRownum - offset;
                        } else if (subOp == SQLBinaryOperator.LessThan) {
                            limit = subRownum - 1 - offset;
                        }
                        if (limit != null) {
                            subSelect.accept(this);
                            this.println();
                            this.print0(this.ucase ? "LIMIT " : "limit ");
                            this.print(offset);
                            this.print0(", ");
                            this.print(limit);
                            return false;
                        }
                    }
                }
            }
        }
        return super.visit(x);
    }

    static boolean isRowNumber(SQLExpr expr) {
        if (expr instanceof SQLIdentifierExpr) {
            return ((SQLIdentifierExpr)expr).hashCode64() == FnvHash.Constants.ROWNUM;
        }
        return false;
    }
}

