/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.oscar.visitor;

import com.hundsun.lightdb.shaded.com.alibaba.druid.DbType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.SQLName;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLTableSampling;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.oscar.visitor.OscarOutputVisitor;
import java.util.List;

public class OscarPermissionOutputVisitor
extends OscarOutputVisitor {
    public OscarPermissionOutputVisitor(Appendable appender) {
        super(appender);
        this.dbType = DbType.oscar;
    }

    public OscarPermissionOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.oscar;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        String catalog = x.getCatalog();
        String schema = x.getSchema();
        String tableName = x.getTableName();
        List<SQLName> columns1 = x.getColumns();
        int sourceColumn = x.getSourceColumn();
        this.print(" (");
        this.print0(this.ucase ? "SELECT " : "select ");
        this.print('*');
        this.print0(this.ucase ? " FROM " : " from ");
        this.printTableSourceExpr(x.getExpr());
        this.print(')');
        SQLTableSampling sampling = x.getSampling();
        if (sampling != null) {
            this.print(' ');
            sampling.accept(this);
        }
        String alias = x.getAlias();
        List<SQLName> columns = x.getColumnsDirect();
        if (alias != null) {
            this.print(' ');
            if (columns != null && columns.size() > 0) {
                this.print0(this.ucase ? " AS " : " as ");
            }
            this.print0(alias);
        }
        if (columns != null && columns.size() > 0) {
            this.print(" (");
            this.printAndAccept(columns, ", ");
            this.print(')');
        }
        for (int i = 0; i < x.getHintsSize(); ++i) {
            this.print(' ');
            x.getHints().get(i).accept(this);
        }
        if (x.getPartitionSize() > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printlnAndAccept(x.getPartitions(), ", ");
            this.print(')');
        }
        return false;
    }
}

