/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.support.http.stat;

import com.hundsun.lightdb.shaded.com.alibaba.druid.support.http.stat.WebRequestStat;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.http.stat.WebURIStatValue;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.profile.ProfileStat;
import com.hundsun.lightdb.shaded.com.alibaba.druid.util.JdbcSqlStatUtils;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class WebURIStat {
    private final String uri;
    private volatile int runningCount;
    private volatile int concurrentMax;
    private volatile long requestCount;
    private volatile long requestTimeNano;
    private volatile long requestTimeNanoMax;
    private volatile long requestTimeNanoMaxOccurTime;
    static final AtomicIntegerFieldUpdater<WebURIStat> runningCountUpdater = AtomicIntegerFieldUpdater.newUpdater(WebURIStat.class, "runningCount");
    static final AtomicIntegerFieldUpdater<WebURIStat> concurrentMaxUpdater = AtomicIntegerFieldUpdater.newUpdater(WebURIStat.class, "concurrentMax");
    static final AtomicLongFieldUpdater<WebURIStat> requestCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "requestCount");
    static final AtomicLongFieldUpdater<WebURIStat> requestTimeNanoUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "requestTimeNano");
    static final AtomicLongFieldUpdater<WebURIStat> requestTimeNanoMaxUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "requestTimeNanoMax");
    static final AtomicLongFieldUpdater<WebURIStat> requestTimeNanoMaxOccurTimeUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "requestTimeNanoMaxOccurTime");
    private volatile long jdbcFetchRowCount;
    private volatile long jdbcFetchRowPeak;
    static final AtomicLongFieldUpdater<WebURIStat> jdbcFetchRowCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcFetchRowCount");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcFetchRowPeakUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcFetchRowPeak");
    private volatile long jdbcUpdateCount;
    private volatile long jdbcUpdatePeak;
    static final AtomicLongFieldUpdater<WebURIStat> jdbcUpdateCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcUpdateCount");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcUpdatePeakUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcUpdatePeak");
    private volatile long jdbcExecuteCount;
    private volatile long jdbcExecuteErrorCount;
    private volatile long jdbcExecutePeak;
    private volatile long jdbcExecuteTimeNano;
    static final AtomicLongFieldUpdater<WebURIStat> jdbcExecuteCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcExecuteCount");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcExecuteErrorCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcExecuteErrorCount");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcExecutePeakUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcExecutePeak");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcExecuteTimeNanoUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcExecuteTimeNano");
    private volatile long jdbcCommitCount;
    private volatile long jdbcRollbackCount;
    static final AtomicLongFieldUpdater<WebURIStat> jdbcCommitCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcCommitCount");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcRollbackCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcRollbackCount");
    private volatile long jdbcPoolConnectionOpenCount;
    private volatile long jdbcPoolConnectionCloseCount;
    static final AtomicLongFieldUpdater<WebURIStat> jdbcPoolConnectionOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcPoolConnectionOpenCount");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcPoolConnectionCloseCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcPoolConnectionCloseCount");
    private volatile long jdbcResultSetOpenCount;
    private volatile long jdbcResultSetCloseCount;
    private volatile long errorCount;
    private volatile long lastAccessTimeMillis = -1L;
    private volatile ProfileStat profiletat = new ProfileStat();
    static final AtomicLongFieldUpdater<WebURIStat> jdbcResultSetOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcResultSetOpenCount");
    static final AtomicLongFieldUpdater<WebURIStat> jdbcResultSetCloseCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "jdbcResultSetCloseCount");
    static final AtomicLongFieldUpdater<WebURIStat> errorCountUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "errorCount");
    static final AtomicLongFieldUpdater<WebURIStat> lastAccessTimeMillisUpdater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "lastAccessTimeMillis");
    private static final ThreadLocal<WebURIStat> currentLocal = new ThreadLocal();
    private volatile long histogram_0_1;
    private volatile long histogram_1_10;
    private volatile long histogram_10_100;
    private volatile long histogram_100_1000;
    private volatile int histogram_1000_10000;
    private volatile int histogram_10000_100000;
    private volatile int histogram_100000_1000000;
    private volatile int histogram_1000000_more;
    static final AtomicLongFieldUpdater<WebURIStat> histogram_0_1_Updater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "histogram_0_1");
    static final AtomicLongFieldUpdater<WebURIStat> histogram_1_10_Updater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "histogram_1_10");
    static final AtomicLongFieldUpdater<WebURIStat> histogram_10_100_Updater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "histogram_10_100");
    static final AtomicLongFieldUpdater<WebURIStat> histogram_100_1000_Updater = AtomicLongFieldUpdater.newUpdater(WebURIStat.class, "histogram_100_1000");
    static final AtomicIntegerFieldUpdater<WebURIStat> histogram_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(WebURIStat.class, "histogram_1000_10000");
    static final AtomicIntegerFieldUpdater<WebURIStat> histogram_10000_100000_Updater = AtomicIntegerFieldUpdater.newUpdater(WebURIStat.class, "histogram_10000_100000");
    static final AtomicIntegerFieldUpdater<WebURIStat> histogram_100000_1000000_Updater = AtomicIntegerFieldUpdater.newUpdater(WebURIStat.class, "histogram_100000_1000000");
    static final AtomicIntegerFieldUpdater<WebURIStat> histogram_1000000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(WebURIStat.class, "histogram_1000000_more");

    public WebURIStat(String uri) {
        this.uri = uri;
    }

    public static WebURIStat current() {
        return currentLocal.get();
    }

    public String getUri() {
        return this.uri;
    }

    public void beforeInvoke() {
        int max;
        currentLocal.set(this);
        int running = runningCountUpdater.incrementAndGet(this);
        while (running > (max = concurrentMaxUpdater.get(this)) && !concurrentMaxUpdater.compareAndSet(this, max, running)) {
        }
        requestCountUpdater.incrementAndGet(this);
        WebRequestStat requestStat = WebRequestStat.current();
        if (requestStat != null) {
            this.setLastAccessTimeMillis(requestStat.getStartMillis());
        }
    }

    public void afterInvoke(Throwable error, long nanos) {
        WebRequestStat localStat;
        long current;
        runningCountUpdater.decrementAndGet(this);
        requestTimeNanoUpdater.addAndGet(this, nanos);
        while ((current = requestTimeNanoMaxUpdater.get(this)) < nanos) {
            if (!requestTimeNanoMaxUpdater.compareAndSet(this, current, nanos)) continue;
            this.requestTimeNanoMaxOccurTime = System.currentTimeMillis();
            break;
        }
        this.histogramRecord(nanos);
        if (error != null) {
            errorCountUpdater.incrementAndGet(this);
        }
        if ((localStat = WebRequestStat.current()) != null) {
            long peak;
            long fetchRowCount = localStat.getJdbcFetchRowCount();
            this.addJdbcFetchRowCount(fetchRowCount);
            while (fetchRowCount > (peak = jdbcFetchRowPeakUpdater.get(this)) && !jdbcFetchRowPeakUpdater.compareAndSet(this, peak, fetchRowCount)) {
            }
            long executeCount = localStat.getJdbcExecuteCount();
            this.addJdbcExecuteCount(executeCount);
            while (executeCount > (peak = jdbcExecutePeakUpdater.get(this)) && !jdbcExecutePeakUpdater.compareAndSet(this, peak, executeCount)) {
            }
            long updateCount = localStat.getJdbcUpdateCount();
            this.addJdbcUpdateCount(updateCount);
            while (updateCount > (peak = jdbcUpdatePeakUpdater.get(this)) && !jdbcUpdatePeakUpdater.compareAndSet(this, peak, updateCount)) {
            }
            jdbcExecuteErrorCountUpdater.addAndGet(this, localStat.getJdbcExecuteErrorCount());
            jdbcExecuteTimeNanoUpdater.addAndGet(this, localStat.getJdbcExecuteTimeNano());
            this.addJdbcPoolConnectionOpenCount(localStat.getJdbcPoolConnectionOpenCount());
            this.addJdbcPoolConnectionCloseCount(localStat.getJdbcPoolConnectionCloseCount());
            this.addJdbcResultSetOpenCount(localStat.getJdbcResultSetOpenCount());
            this.addJdbcResultSetCloseCount(localStat.getJdbcResultSetCloseCount());
        }
        currentLocal.set(null);
    }

    private void histogramRecord(long nanos) {
        long millis = nanos / 1000L / 1000L;
        if (millis < 1L) {
            histogram_0_1_Updater.incrementAndGet(this);
        } else if (millis < 10L) {
            histogram_1_10_Updater.incrementAndGet(this);
        } else if (millis < 100L) {
            histogram_10_100_Updater.incrementAndGet(this);
        } else if (millis < 1000L) {
            histogram_100_1000_Updater.incrementAndGet(this);
        } else if (millis < 10000L) {
            histogram_1000_10000_Updater.incrementAndGet(this);
        } else if (millis < 100000L) {
            histogram_10000_100000_Updater.incrementAndGet(this);
        } else if (millis < 1000000L) {
            histogram_100000_1000000_Updater.incrementAndGet(this);
        } else {
            histogram_1000000_more_Updater.incrementAndGet(this);
        }
    }

    public int getRunningCount() {
        return this.runningCount;
    }

    public long getConcurrentMax() {
        return this.concurrentMax;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public long getRequestTimeNano() {
        return this.requestTimeNano;
    }

    public long getRequestTimeMillis() {
        return this.getRequestTimeNano() / 1000000L;
    }

    public void addJdbcFetchRowCount(long delta) {
        jdbcFetchRowCountUpdater.addAndGet(this, delta);
    }

    public long getJdbcFetchRowCount() {
        return this.jdbcFetchRowCount;
    }

    public long getJdbcFetchRowPeak() {
        return this.jdbcFetchRowPeak;
    }

    public void addJdbcUpdateCount(long updateCount) {
        jdbcUpdateCountUpdater.addAndGet(this, updateCount);
    }

    public long getJdbcUpdateCount() {
        return this.jdbcUpdateCount;
    }

    public long getJdbcUpdatePeak() {
        return this.jdbcUpdatePeak;
    }

    public void incrementJdbcExecuteCount() {
        jdbcExecuteCountUpdater.incrementAndGet(this);
    }

    public void addJdbcExecuteCount(long executeCount) {
        jdbcExecuteCountUpdater.addAndGet(this, executeCount);
    }

    public long getJdbcExecuteCount() {
        return this.jdbcExecuteCount;
    }

    public long getJdbcExecuteErrorCount() {
        return this.jdbcExecuteErrorCount;
    }

    public long getJdbcExecutePeak() {
        return this.jdbcExecutePeak;
    }

    public long getJdbcExecuteTimeMillis() {
        return this.getJdbcExecuteTimeNano() / 1000000L;
    }

    public long getJdbcExecuteTimeNano() {
        return this.jdbcExecuteTimeNano;
    }

    public void incrementJdbcCommitCount() {
        jdbcCommitCountUpdater.incrementAndGet(this);
    }

    public long getJdbcCommitCount() {
        return this.jdbcCommitCount;
    }

    public void incrementJdbcRollbackCount() {
        jdbcRollbackCountUpdater.incrementAndGet(this);
    }

    public long getJdbcRollbackCount() {
        return this.jdbcRollbackCount;
    }

    public void setLastAccessTimeMillis(long lastAccessTimeMillis) {
        this.lastAccessTimeMillis = lastAccessTimeMillis;
    }

    public Date getLastAccessTime() {
        if (this.lastAccessTimeMillis < 0L) {
            return null;
        }
        return new Date(this.lastAccessTimeMillis);
    }

    public long getLastAccessTimeMillis() {
        return this.lastAccessTimeMillis;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public long getJdbcPoolConnectionOpenCount() {
        return this.jdbcPoolConnectionOpenCount;
    }

    public void addJdbcPoolConnectionOpenCount(long delta) {
        jdbcPoolConnectionOpenCountUpdater.addAndGet(this, delta);
    }

    public void incrementJdbcPoolConnectionOpenCount() {
        jdbcPoolConnectionOpenCountUpdater.incrementAndGet(this);
    }

    public long getJdbcPoolConnectionCloseCount() {
        return this.jdbcPoolConnectionCloseCount;
    }

    public void addJdbcPoolConnectionCloseCount(long delta) {
        jdbcPoolConnectionCloseCountUpdater.addAndGet(this, delta);
    }

    public void incrementJdbcPoolConnectionCloseCount() {
        jdbcPoolConnectionCloseCountUpdater.incrementAndGet(this);
    }

    public long getJdbcResultSetOpenCount() {
        return this.jdbcResultSetOpenCount;
    }

    public void addJdbcResultSetOpenCount(long delta) {
        jdbcResultSetOpenCountUpdater.addAndGet(this, delta);
    }

    public long getJdbcResultSetCloseCount() {
        return this.jdbcResultSetCloseCount;
    }

    public void addJdbcResultSetCloseCount(long delta) {
        jdbcResultSetCloseCountUpdater.addAndGet(this, delta);
    }

    public ProfileStat getProfiletat() {
        return this.profiletat;
    }

    public long[] getHistogramValues() {
        return new long[]{this.histogram_0_1, this.histogram_1_10, this.histogram_10_100, this.histogram_100_1000, this.histogram_1000_10000, this.histogram_10000_100000, this.histogram_100000_1000000, this.histogram_1000000_more};
    }

    public WebURIStatValue getValue(boolean reset) {
        WebURIStatValue val = new WebURIStatValue();
        val.setUri(this.uri);
        val.setRunningCount(this.runningCount);
        val.setConcurrentMax(JdbcSqlStatUtils.get(this, concurrentMaxUpdater, reset));
        val.setRequestCount(JdbcSqlStatUtils.get(this, requestCountUpdater, reset));
        val.setRequestTimeNano(JdbcSqlStatUtils.get(this, requestTimeNanoUpdater, reset));
        val.setRequestTimeNanoMax(JdbcSqlStatUtils.get(this, requestTimeNanoMaxUpdater, reset));
        val.setRequestTimeNanoMaxOccurTime(JdbcSqlStatUtils.get(this, requestTimeNanoMaxOccurTimeUpdater, reset));
        val.setJdbcFetchRowCount(JdbcSqlStatUtils.get(this, jdbcFetchRowCountUpdater, reset));
        val.setJdbcFetchRowPeak(JdbcSqlStatUtils.get(this, jdbcFetchRowPeakUpdater, reset));
        val.setJdbcUpdateCount(JdbcSqlStatUtils.get(this, jdbcUpdateCountUpdater, reset));
        val.setJdbcUpdatePeak(JdbcSqlStatUtils.get(this, jdbcUpdatePeakUpdater, reset));
        val.setJdbcExecuteCount(JdbcSqlStatUtils.get(this, jdbcExecuteCountUpdater, reset));
        val.setJdbcExecuteErrorCount(JdbcSqlStatUtils.get(this, jdbcExecuteErrorCountUpdater, reset));
        val.setJdbcExecutePeak(JdbcSqlStatUtils.get(this, jdbcExecutePeakUpdater, reset));
        val.setJdbcExecuteTimeNano(JdbcSqlStatUtils.get(this, jdbcExecuteTimeNanoUpdater, reset));
        val.setJdbcCommitCount(JdbcSqlStatUtils.get(this, jdbcCommitCountUpdater, reset));
        val.setJdbcRollbackCount(JdbcSqlStatUtils.get(this, jdbcRollbackCountUpdater, reset));
        val.setJdbcPoolConnectionOpenCount(JdbcSqlStatUtils.get(this, jdbcPoolConnectionOpenCountUpdater, reset));
        val.setJdbcPoolConnectionCloseCount(JdbcSqlStatUtils.get(this, jdbcPoolConnectionCloseCountUpdater, reset));
        val.setJdbcResultSetOpenCount(JdbcSqlStatUtils.get(this, jdbcResultSetOpenCountUpdater, reset));
        val.setJdbcResultSetCloseCount(JdbcSqlStatUtils.get(this, jdbcResultSetCloseCountUpdater, reset));
        val.setErrorCount(JdbcSqlStatUtils.get(this, errorCountUpdater, reset));
        val.setLastAccessTimeMillis(JdbcSqlStatUtils.get(this, lastAccessTimeMillisUpdater, reset));
        val.setProfileEntryStatValueList(this.getProfiletat().getStatValue(reset));
        val.histogram_0_1 = JdbcSqlStatUtils.get(this, histogram_0_1_Updater, reset);
        val.histogram_1_10 = JdbcSqlStatUtils.get(this, histogram_1_10_Updater, reset);
        val.histogram_10_100 = JdbcSqlStatUtils.get(this, histogram_10_100_Updater, reset);
        val.histogram_100_1000 = JdbcSqlStatUtils.get(this, histogram_100_1000_Updater, reset);
        val.histogram_1000_10000 = JdbcSqlStatUtils.get(this, histogram_1000_10000_Updater, reset);
        val.histogram_10000_100000 = JdbcSqlStatUtils.get(this, histogram_10000_100000_Updater, reset);
        val.histogram_100000_1000000 = JdbcSqlStatUtils.get(this, histogram_100000_1000000_Updater, reset);
        val.histogram_1000000_more = JdbcSqlStatUtils.get(this, histogram_1000000_more_Updater, reset);
        return val;
    }

    public Map<String, Object> getStatData() {
        return this.getValue(false).getStatData();
    }
}

