/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.support.ibatis;

import com.hundsun.lightdb.shaded.com.alibaba.druid.support.ibatis.SqlMapClientImplWrapper;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.logging.Log;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.logging.LogFactory;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapExecutor;
import com.ibatis.sqlmap.client.SqlMapTransactionManager;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapSessionImpl;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class IbatisUtils {
    private static Log LOG = LogFactory.getLog(IbatisUtils.class);
    private static boolean VERSION_2_3_4;
    private static Method methodGetId;
    private static Method methodGetResource;
    private static Field sessionField;

    public static boolean isVersion2_3_4() {
        return VERSION_2_3_4;
    }

    public static SqlMapExecutor setClientImpl(SqlMapExecutor session, SqlMapClientImplWrapper clientImplWrapper) {
        if (session == null || clientImplWrapper == null) {
            return session;
        }
        if (session.getClass() == SqlMapSessionImpl.class) {
            SqlMapSessionImpl sessionImpl = (SqlMapSessionImpl)session;
            IbatisUtils.set(sessionImpl, clientImplWrapper);
        }
        return session;
    }

    protected static String getId(Object statement) {
        try {
            Object returnValue;
            if (methodGetId == null) {
                Class<?> clazz = statement.getClass();
                methodGetId = clazz.getMethod("getId", new Class[0]);
            }
            if ((returnValue = methodGetId.invoke(statement, new Object[0])) == null) {
                return null;
            }
            return returnValue.toString();
        }
        catch (Exception ex) {
            LOG.error("createIdError", ex);
            return null;
        }
    }

    protected static String getResource(Object statement) {
        try {
            if (methodGetResource == null) {
                methodGetResource = statement.getClass().getMethod("getResource", new Class[0]);
            }
            return (String)methodGetResource.invoke(statement, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void set(SqlMapSessionImpl session, SqlMapClientImpl client) {
        if (sessionField == null) {
            for (Field field : SqlMapSessionImpl.class.getDeclaredFields()) {
                if (!field.getName().equals("session") && !field.getName().equals("sessionScope")) continue;
                sessionField = field;
                sessionField.setAccessible(true);
                break;
            }
        }
        if (sessionField != null) {
            try {
                SessionScope sessionScope = (SessionScope)sessionField.get(session);
                if (sessionScope != null) {
                    if (sessionScope.getSqlMapClient() != null && sessionScope.getSqlMapClient().getClass() == SqlMapClientImpl.class) {
                        sessionScope.setSqlMapClient((SqlMapClient)client);
                    }
                    if (sessionScope.getSqlMapExecutor() != null && sessionScope.getSqlMapExecutor().getClass() == SqlMapClientImpl.class) {
                        sessionScope.setSqlMapExecutor((SqlMapExecutor)client);
                    }
                    if (sessionScope.getSqlMapTxMgr() != null && sessionScope.getSqlMapTxMgr().getClass() == SqlMapClientImpl.class) {
                        sessionScope.setSqlMapTxMgr((SqlMapTransactionManager)client);
                    }
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }

    static {
        try {
            Method[] methods;
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("com.ibatis.sqlmap.engine.mapping.result.AutoResultMap");
            for (Method method : methods = clazz.getMethods()) {
                if (!method.getName().equals("setResultObjectValues")) continue;
                VERSION_2_3_4 = true;
                break;
            }
        }
        catch (Throwable e) {
            LOG.error("Error while initializing", e);
        }
    }
}

