/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.support.profile;

import com.hundsun.lightdb.shaded.com.alibaba.druid.support.profile.ProfileEntry;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.profile.ProfileEntryKey;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.profile.ProfileEntryReqStat;
import java.util.LinkedHashMap;
import java.util.Map;

public class Profiler {
    public static final String PROFILE_TYPE_WEB = "WEB";
    public static final String PROFILE_TYPE_SPRING = "SPRING";
    public static final String PROFILE_TYPE_SQL = "SQL";
    private static ThreadLocal<Map<ProfileEntryKey, ProfileEntryReqStat>> statsMapLocal = new ThreadLocal();
    private static final ThreadLocal<ProfileEntry> currentLocal = new ThreadLocal();

    public static boolean isEnable() {
        return statsMapLocal != null;
    }

    public static void enter(String name, String type) {
        if (!Profiler.isEnable()) {
            return;
        }
        ProfileEntry parent = currentLocal.get();
        String parentName = null;
        if (parent != null) {
            parentName = parent.getName();
        }
        ProfileEntryKey key = new ProfileEntryKey(parentName, name, type);
        ProfileEntry entry = new ProfileEntry(parent, key);
        currentLocal.set(entry);
    }

    public static ProfileEntry current() {
        return currentLocal.get();
    }

    public static void release(long nanos) {
        ProfileEntry current = currentLocal.get();
        if (current == null) {
            return;
        }
        currentLocal.set(current.getParent());
        ProfileEntryReqStat stat = null;
        Map<ProfileEntryKey, ProfileEntryReqStat> statsMap = statsMapLocal.get();
        if (statsMap == null) {
            return;
        }
        stat = statsMap.get(current.getKey());
        if (stat == null) {
            stat = new ProfileEntryReqStat();
            statsMap.put(current.getKey(), stat);
        }
        stat.incrementExecuteCount();
        stat.addExecuteTimeNanos(nanos);
    }

    public static Map<ProfileEntryKey, ProfileEntryReqStat> getStatsMap() {
        return statsMapLocal.get();
    }

    public static void initLocal() {
        statsMapLocal.set(new LinkedHashMap());
    }

    public static void removeLocal() {
        statsMapLocal.remove();
    }
}

