/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.support.spring.stat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

public class BeanTypeAutoProxyCreator
extends AbstractAutoProxyCreator
implements InitializingBean,
ApplicationContextAware {
    private static final long serialVersionUID = -9094985530794052264L;
    private Class<?> targetBeanType;
    private ApplicationContext context;
    private List<String> beanNames = new ArrayList<String>();

    public void setTargetBeanType(Class<?> targetClass) {
        this.targetBeanType = targetClass;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String beanName, TargetSource targetSource) {
        for (String mappedName : this.beanNames) {
            if (FactoryBean.class.isAssignableFrom(beanClass)) {
                if (!mappedName.startsWith("&")) continue;
                mappedName = mappedName.substring("&".length());
            }
            if (!this.isMatch(beanName, mappedName)) continue;
            return PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
        }
        return DO_NOT_PROXY;
    }

    protected boolean isMatch(String beanName, String mappedName) {
        return PatternMatchUtils.simpleMatch((String)mappedName, (String)beanName);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.targetBeanType, (String)"targetType cannot be null");
        String[] beanNames = this.context.getBeanNamesForType(this.targetBeanType);
        Collections.addAll(this.beanNames, beanNames);
    }
}

