/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.support.spring.stat;

import com.hundsun.lightdb.shaded.com.alibaba.druid.filter.stat.StatFilterContext;
import com.hundsun.lightdb.shaded.com.alibaba.druid.filter.stat.StatFilterContextListenerAdapter;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.logging.Log;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.logging.LogFactory;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.spring.stat.SpringMethodInfo;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.spring.stat.SpringMethodStat;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.spring.stat.SpringStat;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.spring.stat.SpringStatManager;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DruidStatInterceptor
implements MethodInterceptor,
InitializingBean,
DisposableBean {
    public static final String PROP_NAME_PROFILE = "druid.profile";
    private static final Log LOG = LogFactory.getLog(DruidStatInterceptor.class);
    private static SpringStat springStat = new SpringStat();
    private SpringMethodContextListener statContextListener = new SpringMethodContextListener();

    public void afterPropertiesSet() throws Exception {
        SpringStatManager.getInstance().addSpringStat(springStat);
        StatFilterContext.getInstance().addContextListener(this.statContextListener);
    }

    public void destroy() throws Exception {
        StatFilterContext.getInstance().removeContextListener(this.statContextListener);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        SpringMethodStat lastMethodStat = SpringMethodStat.current();
        SpringMethodInfo methodInfo = this.getMethodInfo(invocation);
        SpringMethodStat methodStat = springStat.getMethodStat(methodInfo, true);
        if (methodStat != null) {
            methodStat.beforeInvoke();
        }
        long startNanos = System.nanoTime();
        Throwable error = null;
        try {
            Object object = invocation.proceed();
            return object;
        }
        catch (Throwable e) {
            error = e;
            throw e;
        }
        finally {
            long endNanos = System.nanoTime();
            long nanos = endNanos - startNanos;
            if (methodStat != null) {
                methodStat.afterInvoke(error, nanos);
            }
            SpringMethodStat.setCurrent(lastMethodStat);
        }
    }

    public SpringMethodInfo getMethodInfo(MethodInvocation invocation) {
        Object thisObject = invocation.getThis();
        Method method = invocation.getMethod();
        if (thisObject == null) {
            return new SpringMethodInfo(method.getDeclaringClass(), method);
        }
        if (method.getDeclaringClass() == thisObject.getClass()) {
            return new SpringMethodInfo(method.getDeclaringClass(), method);
        }
        Class clazz = thisObject.getClass();
        boolean isCglibProxy = false;
        boolean isJavassistProxy = false;
        for (Class<?> item : clazz.getInterfaces()) {
            if (item.getName().equals("net.sf.cglib.proxy.Factory")) {
                isCglibProxy = true;
                break;
            }
            if (!item.getName().equals("javassist.util.proxy.ProxyObject")) continue;
            isJavassistProxy = true;
            break;
        }
        if (isCglibProxy || isJavassistProxy) {
            Class<?> superClazz = clazz.getSuperclass();
            return new SpringMethodInfo(superClazz, method);
        }
        clazz = null;
        try {
            TargetSource targetSource;
            for (int i = 0; i < 10 && thisObject instanceof Advised && (targetSource = ((Advised)thisObject).getTargetSource()) != null; ++i) {
                Object target = targetSource.getTarget();
                if (target == null) {
                    clazz = targetSource.getTargetClass();
                    break;
                }
                thisObject = target;
            }
        }
        catch (Exception ex) {
            LOG.error("getMethodInfo error", ex);
        }
        if (clazz == null) {
            return new SpringMethodInfo(method.getDeclaringClass(), method);
        }
        return new SpringMethodInfo(clazz, method);
    }

    class SpringMethodContextListener
    extends StatFilterContextListenerAdapter {
        SpringMethodContextListener() {
        }

        @Override
        public void addUpdateCount(int updateCount) {
            SpringMethodStat springMethodStat = SpringMethodStat.current();
            if (springMethodStat != null) {
                springMethodStat.addJdbcUpdateCount(updateCount);
            }
        }

        @Override
        public void addFetchRowCount(int fetchRowCount) {
            SpringMethodStat springMethodStat = SpringMethodStat.current();
            if (springMethodStat != null) {
                springMethodStat.addJdbcFetchRowCount(fetchRowCount);
            }
        }

        @Override
        public void executeBefore(String sql, boolean inTransaction) {
            SpringMethodStat springMethodStat = SpringMethodStat.current();
            if (springMethodStat != null) {
                springMethodStat.incrementJdbcExecuteCount();
            }
        }

        @Override
        public void executeAfter(String sql, long nanos, Throwable error) {
            SpringMethodStat springMethodStat = SpringMethodStat.current();
            if (springMethodStat != null) {
                springMethodStat.addJdbcExecuteTimeNano(nanos);
                if (error != null) {
                    springMethodStat.incrementJdbcExecuteErrorCount();
                }
            }
        }

        @Override
        public void commit() {
            SpringMethodStat springMethodStat = SpringMethodStat.current();
            if (springMethodStat != null) {
                springMethodStat.incrementJdbcCommitCount();
            }
        }

        @Override
        public void rollback() {
            SpringMethodStat springMethodStat = SpringMethodStat.current();
            if (springMethodStat != null) {
                springMethodStat.incrementJdbcRollbackCount();
            }
        }

        @Override
        public void pool_connect() {
            SpringMethodStat springMethodStat = SpringMethodStat.current();
            if (springMethodStat != null) {
                springMethodStat.incrementJdbcPoolConnectionOpenCount();
            }
        }

        @Override
        public void pool_close(long nanos) {
            SpringMethodStat springMethodStat = SpringMethodStat.current();
            if (springMethodStat != null) {
                springMethodStat.incrementJdbcPoolConnectionCloseCount();
            }
        }

        @Override
        public void resultSet_open() {
            SpringMethodStat springMethodStat = SpringMethodStat.current();
            if (springMethodStat != null) {
                springMethodStat.incrementJdbcResultSetOpenCount();
            }
        }

        @Override
        public void resultSet_close(long nanos) {
            SpringMethodStat springMethodStat = SpringMethodStat.current();
            if (springMethodStat != null) {
                springMethodStat.incrementJdbcResultSetCloseCount();
            }
        }
    }
}

