/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.support.spring.stat;

import com.hundsun.lightdb.shaded.com.alibaba.druid.support.logging.Log;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.logging.LogFactory;
import com.hundsun.lightdb.shaded.com.alibaba.druid.support.spring.stat.SpringStat;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class SpringStatUtils {
    private static final Log LOG = LogFactory.getLog(SpringStatUtils.class);

    public static List<Map<String, Object>> getMethodStatDataList(Object methodStat) {
        if (methodStat.getClass() == SpringStat.class) {
            return ((SpringStat)methodStat).getMethodStatDataList();
        }
        try {
            Method method = methodStat.getClass().getMethod("getMethodStatDataList", new Class[0]);
            Object obj = method.invoke(methodStat, new Object[0]);
            return (List)obj;
        }
        catch (Exception e) {
            LOG.error("getMethodStatDataList error", e);
            return null;
        }
    }

    public static Map<String, Object> getMethodStatData(Object methodStat, String clazz, String methodSignature) {
        if (methodStat.getClass() == SpringStat.class) {
            return ((SpringStat)methodStat).getMethodStatData(clazz, methodSignature);
        }
        try {
            Method method = methodStat.getClass().getMethod("getMethodStatData", String.class, String.class);
            Object obj = method.invoke(methodStat, clazz, methodSignature);
            return (Map)obj;
        }
        catch (Exception e) {
            LOG.error("getMethodStatDataList error", e);
            return null;
        }
    }

    public static void reset(Object webStat) {
        if (webStat.getClass() == SpringStat.class) {
            ((SpringStat)webStat).reset();
            return;
        }
        try {
            Method method = webStat.getClass().getMethod("reset", new Class[0]);
            method.invoke(webStat, new Object[0]);
        }
        catch (Exception e) {
            LOG.error("reset error", e);
        }
    }
}

