/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.jdbcx.JdbcXAConnection;
import org.h2.message.TraceObject;

public class H2Utils {
    private static volatile Constructor<JdbcXAConnection> constructor;
    private static volatile Method method;
    public static final int XA_DATA_SOURCE = 13;

    public static Object createJdbcDataSourceFactory() {
        return new JdbcDataSourceFactory();
    }

    public static XAConnection createXAConnection(Object factory, Connection physicalConn) throws SQLException {
        try {
            if (constructor == null) {
                constructor = JdbcXAConnection.class.getDeclaredConstructor(JdbcDataSourceFactory.class, Integer.TYPE, JdbcConnection.class);
                constructor.setAccessible(true);
            }
            int id = H2Utils.getNextId(13);
            return (XAConnection)constructor.newInstance(factory, id, physicalConn);
        }
        catch (Exception e) {
            throw new SQLException("createXAConnection error", e);
        }
    }

    public static int getNextId(int type) throws Exception {
        if (method == null) {
            method = TraceObject.class.getDeclaredMethod("getNextId", Integer.TYPE);
            method.setAccessible(true);
        }
        return (Integer)method.invoke(null, type);
    }
}

