/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.wall.spi;

import com.hundsun.lightdb.shaded.com.alibaba.druid.DbType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMultiInsertStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.hundsun.lightdb.shaded.com.alibaba.druid.wall.WallProvider;
import com.hundsun.lightdb.shaded.com.alibaba.druid.wall.WallVisitor;
import com.hundsun.lightdb.shaded.com.alibaba.druid.wall.spi.WallVisitorBase;
import com.hundsun.lightdb.shaded.com.alibaba.druid.wall.spi.WallVisitorUtils;
import com.hundsun.lightdb.shaded.com.alibaba.druid.wall.violation.IllegalSQLObjectViolation;

public class OracleWallVisitor
extends WallVisitorBase
implements WallVisitor,
OracleASTVisitor {
    public OracleWallVisitor(WallProvider provider) {
        super(provider);
    }

    @Override
    public DbType getDbType() {
        return DbType.oracle;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        String name = x.getName();
        name = WallVisitorUtils.form(name);
        if (this.config.isVariantCheck() && this.config.getDenyVariants().contains(name)) {
            this.getViolations().add(new IllegalSQLObjectViolation(2003, "variable not allow : " + name, this.toSQL(x)));
        }
        return true;
    }

    @Override
    public boolean visit(OracleSelectTableReference x) {
        return WallVisitorUtils.check((WallVisitor)this, x);
    }

    @Override
    public boolean isDenyTable(String name) {
        if (!this.config.isTableCheck()) {
            return false;
        }
        if ((name = WallVisitorUtils.form(name)).startsWith("v$") || name.startsWith("v_$")) {
            return true;
        }
        return !this.provider.checkDenyTable(name);
    }

    @Override
    public boolean visit(OracleMultiInsertStatement.InsertIntoClause x) {
        WallVisitorUtils.checkInsert(this, x);
        return true;
    }

    @Override
    public boolean visit(OracleMultiInsertStatement x) {
        if (!this.config.isInsertAllow()) {
            this.getViolations().add(new IllegalSQLObjectViolation(1004, "insert not allow", this.toSQL(x)));
            return false;
        }
        WallVisitorUtils.initWallTopStatementContext();
        return true;
    }

    @Override
    public void endVisit(OracleMultiInsertStatement x) {
        WallVisitorUtils.clearWallTopStatementContext();
    }
}

