/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.shaded.com.alibaba.druid.wall.spi;

import com.hundsun.lightdb.shaded.com.alibaba.druid.wall.Violation;
import com.hundsun.lightdb.shaded.com.alibaba.druid.wall.WallConfig;
import com.hundsun.lightdb.shaded.com.alibaba.druid.wall.WallProvider;
import com.hundsun.lightdb.shaded.com.alibaba.druid.wall.WallUpdateCheckItem;
import com.hundsun.lightdb.shaded.com.alibaba.druid.wall.WallVisitor;
import java.util.ArrayList;
import java.util.List;

public abstract class WallVisitorBase
implements WallVisitor {
    protected final WallConfig config;
    protected final WallProvider provider;
    protected final List<Violation> violations = new ArrayList<Violation>();
    protected boolean sqlModified;
    protected boolean sqlEndOfComment;
    protected List<WallUpdateCheckItem> updateCheckItems;

    public WallVisitorBase(WallProvider provider) {
        this.config = provider.getConfig();
        this.provider = provider;
    }

    @Override
    public boolean isSqlModified() {
        return this.sqlModified;
    }

    @Override
    public void setSqlModified(boolean sqlModified) {
        this.sqlModified = sqlModified;
    }

    @Override
    public WallProvider getProvider() {
        return this.provider;
    }

    @Override
    public WallConfig getConfig() {
        return this.config;
    }

    @Override
    public void addViolation(Violation violation) {
        this.violations.add(violation);
    }

    @Override
    public List<Violation> getViolations() {
        return this.violations;
    }

    @Override
    public boolean isSqlEndOfComment() {
        return this.sqlEndOfComment;
    }

    @Override
    public void setSqlEndOfComment(boolean sqlEndOfComment) {
        this.sqlEndOfComment = sqlEndOfComment;
    }

    @Override
    public void addWallUpdateCheckItem(WallUpdateCheckItem item) {
        if (this.updateCheckItems == null) {
            this.updateCheckItems = new ArrayList<WallUpdateCheckItem>();
        }
        this.updateCheckItems.add(item);
    }

    @Override
    public List<WallUpdateCheckItem> getUpdateCheckItems() {
        return this.updateCheckItems;
    }

    @Override
    public boolean isDenyTable(String name) {
        if (!this.config.isTableCheck()) {
            return false;
        }
        return !this.provider.checkDenyTable(name);
    }
}

