/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.util;

import com.hundsun.lightdb.core.BaseConnection;
import com.hundsun.lightdb.core.QueryExecutor;
import com.hundsun.lightdb.core.QueryExecutorBase;

public class CompatibleUtil {
    public static final String ORACLE = "oracle";
    public static final String MYSQL = "mysql";

    public static boolean isOralce(String compatiableType) {
        return ORACLE.equals(compatiableType);
    }

    public static boolean isMysql(String compatiableType) {
        return MYSQL.equals(compatiableType);
    }

    public static boolean isMysqlCompatible(QueryExecutor queryExecutor) {
        QueryExecutorBase queryExecutorBase = (QueryExecutorBase)queryExecutor;
        return CompatibleUtil.isMysql(queryExecutorBase.getLightdbSyntaxCompatibleType());
    }

    public static boolean isOracleCompatible(QueryExecutor queryExecutor) {
        QueryExecutorBase queryExecutorBase = (QueryExecutorBase)queryExecutor;
        return CompatibleUtil.isOralce(queryExecutorBase.getLightdbSyntaxCompatibleType());
    }

    public static boolean hasCompatibleType(BaseConnection connection) {
        return CompatibleUtil.isMysqlCompatible(connection.getQueryExecutor()) || CompatibleUtil.isOracleCompatible(connection.getQueryExecutor());
    }

    public static boolean isEnforceUtf8(QueryExecutor queryExecutor) {
        QueryExecutorBase queryExecutorBase = (QueryExecutorBase)queryExecutor;
        return queryExecutorBase.isEnforceUtf8();
    }
}

