/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.util;

import com.hundsun.lightdb.util.DataIO;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class DataOutput2
extends OutputStream
implements DataOutput {
    public byte[] buf = new byte[128];
    public int pos = 0;
    public int sizeMask = -1 - (this.buf.length - 1);

    public byte[] copyBytes() {
        return Arrays.copyOf(this.buf, this.pos);
    }

    public void ensureAvail(int n) {
        if (((n += this.pos) & this.sizeMask) != 0) {
            this.grow(n);
        }
    }

    private void grow(int n) {
        int newSize = Math.max(DataIO.nextPowTwo(n), this.buf.length);
        this.sizeMask = -1 - (newSize - 1);
        this.buf = Arrays.copyOf(this.buf, newSize);
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureAvail(1);
        this.buf[this.pos++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureAvail(len);
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.ensureAvail(1);
        this.buf[this.pos++] = (byte)(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.ensureAvail(1);
        this.buf[this.pos++] = (byte)v;
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.ensureAvail(2);
        this.buf[this.pos++] = (byte)(0xFF & v >> 8);
        this.buf[this.pos++] = (byte)(0xFF & v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.ensureAvail(2);
        this.buf[this.pos++] = (byte)(v >>> 8);
        this.buf[this.pos++] = (byte)v;
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.ensureAvail(4);
        this.buf[this.pos++] = (byte)(0xFF & v >> 24);
        this.buf[this.pos++] = (byte)(0xFF & v >> 16);
        this.buf[this.pos++] = (byte)(0xFF & v >> 8);
        this.buf[this.pos++] = (byte)(0xFF & v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.ensureAvail(8);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 56);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 48);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 40);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 32);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 24);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 16);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 8);
        this.buf[this.pos++] = (byte)(0xFFL & v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.writeUTF(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.writeUTF(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int len = s.length();
        this.packInt(len);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            this.packInt(c);
        }
    }

    public void packInt(int value) throws IOException {
        this.ensureAvail(5);
        int shift = value & 0xFFFFFF80;
        if (shift != 0) {
            shift = 31 - Integer.numberOfLeadingZeros(value);
            shift -= shift % 7;
            while (shift != 0) {
                this.buf[this.pos++] = (byte)(value >>> shift & 0x7F);
                shift -= 7;
            }
        }
        this.buf[this.pos++] = (byte)(value & 0x7F | 0x80);
    }

    public void packIntBigger(int value) throws IOException {
        this.ensureAvail(5);
        int shift = 31 - Integer.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            this.buf[this.pos++] = (byte)(value >>> shift & 0x7F);
            shift -= 7;
        }
        this.buf[this.pos++] = (byte)(value & 0x7F | 0x80);
    }

    public void packLong(long value) {
        this.ensureAvail(10);
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            this.buf[this.pos++] = (byte)(value >>> shift & 0x7FL);
            shift -= 7;
        }
        this.buf[this.pos++] = (byte)(value & 0x7FL | 0x80L);
    }

    public void packLongArray(long[] array, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            long value = array[i];
            this.ensureAvail(10);
            int shift = 63 - Long.numberOfLeadingZeros(value);
            shift -= shift % 7;
            while (shift != 0) {
                this.buf[this.pos++] = (byte)(value >>> shift & 0x7FL);
                shift -= 7;
            }
            this.buf[this.pos++] = (byte)(value & 0x7FL | 0x80L);
        }
    }
}

