/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.util;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateUtils {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final LocalDate DATE_MILLENNIUM = LocalDate.of(2000, 1, 1);
    private static ThreadLocal<Map<String, SimpleDateFormat>> threadLocal = new ThreadLocal<Map<String, SimpleDateFormat>>(){

        @Override
        protected Map<String, SimpleDateFormat> initialValue() {
            return new HashMap<String, SimpleDateFormat>();
        }
    };

    public static SimpleDateFormat getSimpleDateFormat(String pattern) {
        Map<String, SimpleDateFormat> simpleDateFormatMap = threadLocal.get();
        SimpleDateFormat simpleDateFormat = simpleDateFormatMap.get(pattern);
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat(pattern);
            simpleDateFormatMap.put(pattern, simpleDateFormat);
        }
        return simpleDateFormat;
    }

    public static String convertDateToString(String pattern, Date date) {
        SimpleDateFormat simpleDateFormat = DateUtils.getSimpleDateFormat(pattern);
        if (date != null) {
            return simpleDateFormat.format(date);
        }
        return null;
    }

    public static Date convertStringToDate(String pattern, String dateStr) {
        Date date = null;
        SimpleDateFormat simpleDateFormat = DateUtils.getSimpleDateFormat(pattern);
        if (dateStr != null) {
            try {
                date = simpleDateFormat.parse(dateStr);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return date;
    }

    public static String dateToStr(Date date) {
        return DateUtils.convertDateToString(DEFAULT_DATE_FORMAT, date);
    }

    public static Date strToDate(String str) {
        return DateUtils.convertStringToDate(DEFAULT_DATE_FORMAT, str);
    }

    public static String dateToStr(String pattern, Date date) {
        return DateUtils.convertDateToString(pattern, date);
    }

    public static LocalDate strToLocalDate(String dateStr) {
        return LocalDate.parse(dateStr, DateTimeFormatter.ofPattern(DEFAULT_DATE_FORMAT));
    }

    public static int getEpochDay(LocalDate start, LocalDate end) {
        long day = start.toEpochDay() - end.toEpochDay();
        return (int)day;
    }
}

