/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.util;

import com.hundsun.lightdb.core.Tuple;
import com.hundsun.lightdb.util.EhCacheTupleSerializer;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.Cache;
import org.ehcache.CachePersistenceException;
import org.ehcache.PersistentCacheManager;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;

public class EhCacheStore {
    static AtomicLong SEQ = new AtomicLong(0L);
    static PersistentCacheManager persistentCacheManager;
    static CacheConfigurationBuilder<Integer, Tuple> builder;
    public static final String DEFAULT_FIRST_MAX_SIZE = "100000";
    public static final int FIRST_MAX_SIZE;
    public static final String DEFAULT_HEAP_SIZE = "100000";
    public static final int HEAP_SIZE;
    public static final String DEFAULT_OFF_HEAP_SIZE = "128";
    public static final int OFF_HEAP_SIZE;
    public static final String DEFAULT_DISK_SIZE = "128";
    public static final int DISK_SIZE;

    private static void delete(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                EhCacheStore.delete(f);
            }
        }
        file.delete();
    }

    private static int calcConfig(String key, String defaultVal) {
        String property = System.getenv(key);
        try {
            if (property != null) {
                return Integer.parseInt(property);
            }
            return Integer.parseInt(defaultVal);
        }
        catch (Exception e) {
            return Integer.parseInt(defaultVal);
        }
    }

    public static List<Tuple> alocateList() {
        return new CompositeList();
    }

    private static String nextListId() {
        return "" + SEQ.getAndIncrement();
    }

    public static void clear(List<Tuple> rows) {
        if (rows instanceof CompositeList && rows != null) {
            rows.clear();
        }
    }

    static {
        String tmpDir = System.getProperty("java.io.tmpdir");
        FIRST_MAX_SIZE = EhCacheStore.calcConfig("lightdb.jdbc.resultset.raw", "100000");
        HEAP_SIZE = EhCacheStore.calcConfig("lightdb.jdbc.resultset.heap", "100000");
        OFF_HEAP_SIZE = EhCacheStore.calcConfig("lightdb.jdbc.resultset.offheap", "128");
        DISK_SIZE = EhCacheStore.calcConfig("lightdb.jdbc.resultset.disk", "128");
        File dir = new File(tmpDir + File.separator + "ehcache" + UUID.randomUUID().toString());
        dir.mkdirs();
        persistentCacheManager = CacheManagerBuilder.newCacheManagerBuilder().withSerializer(Tuple.class, EhCacheTupleSerializer.class).with(CacheManagerBuilder.persistence(dir)).build(true);
        builder = CacheConfigurationBuilder.newCacheConfigurationBuilder(Integer.class, Tuple.class, ResourcePoolsBuilder.newResourcePoolsBuilder().heap(HEAP_SIZE, EntryUnit.ENTRIES).offheap(OFF_HEAP_SIZE, MemoryUnit.MB).disk(DISK_SIZE, MemoryUnit.GB, true));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> EhCacheStore.delete(dir)));
    }

    static class CompositeList
    extends AbstractList<Tuple> {
        private List<Tuple> first = new ArrayList<Tuple>();
        private Cache<Integer, Tuple> second;
        private int secondSize;
        private String secondName;

        @Override
        public Tuple set(int index, Tuple element) {
            if (index >= this.size()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
            }
            if (index >= FIRST_MAX_SIZE) {
                if (this.second == null) {
                    this.secondName = EhCacheStore.nextListId();
                    this.second = persistentCacheManager.createCache(this.secondName, builder);
                }
                Tuple tuple = this.second.get(index - FIRST_MAX_SIZE);
                this.second.put(index - FIRST_MAX_SIZE, element);
                return tuple;
            }
            return this.first.set(index, element);
        }

        @Override
        public boolean add(Tuple tuple) {
            if (this.first.size() >= FIRST_MAX_SIZE) {
                if (this.second == null) {
                    this.secondName = EhCacheStore.nextListId();
                    this.second = persistentCacheManager.createCache(this.secondName, builder);
                }
                this.second.put(this.secondSize++, tuple);
                return true;
            }
            return this.first.add(tuple);
        }

        @Override
        public void add(int index, Tuple element) {
            if (index > this.size()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
            }
            if (index >= FIRST_MAX_SIZE) {
                if (this.second == null) {
                    this.secondName = EhCacheStore.nextListId();
                    this.second = persistentCacheManager.createCache(this.secondName, builder);
                    this.second.put(this.secondSize++, element);
                } else {
                    for (int i = this.secondSize - 1; i >= index - FIRST_MAX_SIZE; --i) {
                        this.second.put(i + 1, this.second.get(i));
                    }
                    this.second.put(index - FIRST_MAX_SIZE, element);
                    ++this.secondSize;
                }
            } else {
                this.first.add(index, element);
                if (this.first.size() > FIRST_MAX_SIZE) {
                    Tuple tuple = this.first.get(this.first.size() - 1);
                    this.first.remove(this.first.size() - 1);
                    if (this.second == null) {
                        this.secondName = EhCacheStore.nextListId();
                        this.second = persistentCacheManager.createCache(this.secondName, builder);
                        this.second.put(this.secondSize++, tuple);
                    } else {
                        for (int i = this.secondSize - 1; i <= 0; --i) {
                            this.second.put(i + 1, this.second.get(i));
                        }
                        this.second.put(0, tuple);
                        ++this.secondSize;
                    }
                }
            }
        }

        @Override
        public Tuple remove(int index) {
            if (index >= this.size()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
            }
            if (index >= FIRST_MAX_SIZE) {
                Tuple tuple = this.second.get(index - FIRST_MAX_SIZE);
                for (int i = index - FIRST_MAX_SIZE; i < this.size() - FIRST_MAX_SIZE - 1; ++i) {
                    if (this.second.get(i + 1) == null) continue;
                    this.second.put(i, this.second.get(i + 1));
                }
                if (this.second.containsKey(this.size() - FIRST_MAX_SIZE - 1)) {
                    this.second.remove(this.size() - FIRST_MAX_SIZE - 1);
                }
                --this.secondSize;
                return tuple;
            }
            Tuple removeTuple = this.first.remove(index);
            if (this.secondSize != 0) {
                this.first.add(this.second.get(0));
                for (int i = 0; i < this.secondSize; ++i) {
                    if (this.second.get(i + 1) == null) continue;
                    this.second.put(i, this.second.get(i + 1));
                }
                this.second.remove(--this.secondSize);
            }
            return removeTuple;
        }

        @Override
        public Tuple get(int index) {
            if (index < FIRST_MAX_SIZE) {
                return this.first.get(index);
            }
            return this.second.get(index - FIRST_MAX_SIZE);
        }

        @Override
        public int size() {
            return this.first.size() + this.secondSize;
        }

        @Override
        public boolean isEmpty() {
            return this.first.isEmpty();
        }

        @Override
        public void clear() {
            this.first.clear();
            if (this.second != null) {
                try {
                    this.second = null;
                    this.secondSize = 0;
                    persistentCacheManager.destroyCache(this.secondName);
                }
                catch (CachePersistenceException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

