/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.util;

import com.hundsun.lightdb.core.Tuple;
import com.hundsun.lightdb.util.DataInput2;
import com.hundsun.lightdb.util.DataOutput2;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;

public class EhCacheTupleSerializer
implements Serializer<Tuple> {
    public EhCacheTupleSerializer(ClassLoader classLoader) {
    }

    @Override
    public ByteBuffer serialize(Tuple tuple) throws SerializerException {
        DataOutput2 out = new DataOutput2();
        try {
            out.packInt(tuple.fieldCount());
            for (int i = 0; i < tuple.fieldCount(); ++i) {
                byte[] bytes = tuple.get(i);
                if (bytes == null) {
                    out.packInt(0);
                    continue;
                }
                out.packInt(bytes.length);
                out.write(bytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ByteBuffer.wrap(out.copyBytes());
    }

    @Override
    public Tuple read(ByteBuffer byteBuffer) throws ClassNotFoundException, SerializerException {
        DataInput2.ByteBuffer input = new DataInput2.ByteBuffer(byteBuffer, 0);
        try {
            int fieldCount = input.unpackInt();
            Tuple tuple = new Tuple(fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                int length = input.unpackInt();
                if (length == 0) continue;
                byte[] bytes = new byte[length];
                input.readFully(bytes);
                tuple.set(i, bytes);
            }
            return tuple;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean equals(Tuple tuple, ByteBuffer byteBuffer) throws ClassNotFoundException, SerializerException {
        ByteBuffer buffer = this.serialize(tuple);
        return buffer.equals(byteBuffer);
    }
}

